/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util;

import com.kingdee.util.ConfigurationHelper;
import com.kingdee.util.ConfigurationListener;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public class PropertyConfigurationHelper
implements ConfigurationListener {
    private final String filePath;
    private Properties props = null;
    private long lastModify = 0L;
    private static final Logger logger = Logger.getLogger(PropertyConfigurationHelper.class);

    public PropertyConfigurationHelper(String filePath) {
        this.filePath = filePath;
        ConfigurationHelper.registerListener(this);
    }

    @Override
    public void loadConfig() throws Exception {
        this.props = new Properties();
        File configFile = new File(this.filePath);
        if (!configFile.exists()) {
            logger.error((Object)("Config file does not exist. File path is " + this.filePath));
            return;
        }
        try (FileInputStream in = null;){
            in = new FileInputStream(configFile);
            this.props.load(in);
        }
    }

    @Override
    public boolean isModified() throws Exception {
        File file = new File(this.filePath);
        if (file.exists() && file.lastModified() != this.lastModify) {
            this.lastModify = file.lastModified();
            return true;
        }
        return false;
    }

    public String getProperty(String propertyName) {
        if (this.props != null) {
            return this.props.getProperty(propertyName);
        }
        return null;
    }

    public String getProperty(String propertyName, String _default) {
        String ret = this.getProperty(propertyName);
        if (StringUtils.isEmpty(ret)) {
            ret = _default;
        }
        return ret;
    }

    public Properties getAllProperty() {
        return this.props;
    }

    @Override
    public void exceptionCaught(Exception e) {
        this.lastModify = 0L;
    }
}

