/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util;

import com.kingdee.bos.util.BOSUuid;
import com.kingdee.util.IPropertyContainer;
import com.kingdee.util.IllegalConversionException;
import com.kingdee.util.InvalidDateException;
import com.kingdee.util.Null;
import com.kingdee.util.ObjectUtils;
import com.kingdee.util.SortedStringObjectMap;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.Uuid;
import com.kingdee.util.marshal.ExternalizeDelegate;
import com.kingdee.util.marshal.Marshaller;
import com.kingdee.util.marshal.Unmarshaller;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;

public class PropertyContainer
implements IPropertyContainer {
    private static final long serialVersionUID = -357487513260734379L;
    protected Map values;

    protected PropertyContainer(boolean init) {
    }

    public PropertyContainer(int initialCapacity) {
        this.values = new HashMap(initialCapacity);
    }

    public PropertyContainer() {
        this(30);
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public Object get(String key) {
        Object obj = this.values.get(key.toLowerCase());
        if (obj instanceof Null) {
            return null;
        }
        return obj;
    }

    public Object get(String key, Class clazz) {
        Object obj = this.get(key);
        if (obj == null) {
            return null;
        }
        if (clazz.isInstance(obj)) {
            return obj;
        }
        throw new IllegalConversionException();
    }

    @Override
    public Object get(String key, Object defaultValue) {
        Object obj = this.values.get(key.toLowerCase());
        if (obj == null) {
            return defaultValue;
        }
        if (obj instanceof Null) {
            return null;
        }
        return obj;
    }

    @Override
    public Object put(String key, Object value) {
        String k = key.toLowerCase();
        if (value == null) {
            this.values.put(k, Null.NULL);
            return null;
        }
        return this.values.put(k, value);
    }

    @Override
    public Object remove(String key) {
        return this.values.remove(key.toLowerCase());
    }

    @Override
    public boolean containsKey(String key) {
        return this.values.containsKey(key.toLowerCase());
    }

    @Override
    public Enumeration keys() {
        Object[] keys = this.values.keySet().toArray();
        return new InnerEnumeration(keys);
    }

    @Override
    public Uuid getUuid(String name) throws IllegalConversionException {
        return TypeConversionUtils.objToUuid(this.get(name));
    }

    @Override
    public BOSUuid getBOSUuid(String name) throws IllegalConversionException {
        return TypeConversionUtils.objToBOSUuid(this.get(name));
    }

    @Override
    public String getString(String name) {
        return TypeConversionUtils.objToString(this.get(name));
    }

    @Override
    public BigDecimal getBigDecimal(String name) throws IllegalConversionException {
        return TypeConversionUtils.objToBigDecimal(this.get(name));
    }

    @Override
    public BigDecimal getBigDecimal(String name, int scale) throws IllegalConversionException {
        return TypeConversionUtils.objToBigDecimal(this.get(name), scale);
    }

    @Override
    public boolean getBoolean(String name) throws IllegalConversionException {
        return TypeConversionUtils.objToBoolean(this.get(name));
    }

    @Override
    public byte getByte(String name) throws IllegalConversionException {
        return TypeConversionUtils.objToByte(this.get(name));
    }

    @Override
    public short getShort(String name) throws IllegalConversionException {
        return TypeConversionUtils.objToShort(this.get(name));
    }

    @Override
    public int getInt(String name) throws IllegalConversionException {
        return TypeConversionUtils.objToInt(this.get(name));
    }

    @Override
    public long getLong(String name) throws IllegalConversionException {
        return TypeConversionUtils.objToLong(this.get(name));
    }

    @Override
    public float getFloat(String name) throws IllegalConversionException {
        return TypeConversionUtils.objToFloat(this.get(name));
    }

    @Override
    public double getDouble(String name) throws IllegalConversionException {
        return TypeConversionUtils.objToDouble(this.get(name));
    }

    @Override
    public Time getTime(String name) throws InvalidDateException, IllegalConversionException {
        return TypeConversionUtils.objToTime(this.get(name));
    }

    @Override
    public Date getDate(String name) throws InvalidDateException, IllegalConversionException {
        return TypeConversionUtils.objToDate(this.get(name));
    }

    @Override
    public java.util.Date getUtilDate(String name) throws InvalidDateException, IllegalConversionException {
        return TypeConversionUtils.objToUtilDate(this.get(name));
    }

    @Override
    public Timestamp getTimestamp(String name) throws InvalidDateException, IllegalConversionException {
        return TypeConversionUtils.objToTimestamp(this.get(name));
    }

    @Override
    public byte[] getBytes(String name) throws IllegalConversionException {
        return TypeConversionUtils.objToBytes(this.get(name));
    }

    @Override
    public void setUuid(String name, Uuid id) {
        this.put(name, id);
    }

    @Override
    public void setBOSUuid(String name, BOSUuid id) {
        this.put(name, id);
    }

    @Override
    public void setString(String key, String val) {
        this.put(key, val);
    }

    @Override
    public void setBigDecimal(String key, BigDecimal val) {
        this.put(key, val);
    }

    @Override
    public void setBoolean(String key, boolean b) {
        this.put(key, new Boolean(b));
    }

    @Override
    public void setByte(String name, byte b) {
        this.put(name, new Byte(b));
    }

    @Override
    public void setShort(String name, short s) {
        this.put(name, new Short(s));
    }

    @Override
    public void setInt(String name, int i) {
        this.put(name, i);
    }

    @Override
    public void setLong(String name, long l) {
        this.put(name, l);
    }

    @Override
    public void setFloat(String name, float f) {
        this.put(name, new Float(f));
    }

    @Override
    public void setDouble(String name, double d) {
        this.put(name, new Double(d));
    }

    @Override
    public void setBytes(String name, byte[] bytes) {
        this.put(name, bytes);
    }

    @Override
    public void setDate(String name, Date date) {
        this.put(name, date);
    }

    @Override
    public void setTime(String name, Time time) {
        this.put(name, time);
    }

    @Override
    public void setTimestamp(String name, Timestamp timestamp) {
        this.put(name, timestamp);
    }

    @Override
    public void setDate(String name, java.util.Date date) {
        this.put(name, date);
    }

    @Override
    public void setNull(String name) {
        this.put(name, Null.NULL);
    }

    public boolean equals(Object that) {
        IdentityStack thisRefStack = new IdentityStack();
        IdentityStack thatRefStack = new IdentityStack();
        return PropertyContainer.equals(this, that, thisRefStack, thatRefStack);
    }

    private static final boolean equals(PropertyContainer thisObject, Object thatObject, IdentityStack thisRefStack, IdentityStack thatRefStack) {
        if (thatObject == thisObject) {
            return true;
        }
        if (!(thatObject instanceof PropertyContainer)) {
            return false;
        }
        if (!thisObject.getClass().getName().equals(thatObject.getClass().getName())) {
            return false;
        }
        int thisRefDeepth = thisRefStack.search(thisObject);
        int thatRefDeepth = thatRefStack.search(thatObject);
        if (thisRefDeepth >= 0) {
            return thisRefDeepth == thatRefDeepth;
        }
        thisRefStack.push(thisObject);
        thatRefStack.push(thatObject);
        Map thisValues = thisObject.values;
        Map thatValues = ((PropertyContainer)thatObject).values;
        if (thisValues.size() != thatValues.size()) {
            return false;
        }
        try {
            for (Map.Entry e : thisValues.entrySet()) {
                Object key = e.getKey();
                Object value = e.getValue();
                if (!(value == null ? thatValues.get(key) != null || !thatValues.containsKey(key) : (value instanceof PropertyContainer ? !PropertyContainer.equals((PropertyContainer)value, thatValues.get(key), thisRefStack, thatRefStack) : !value.equals(thatValues.get(key))))) continue;
                return false;
            }
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
        thisRefStack.pop();
        thatRefStack.pop();
        return true;
    }

    public String toString() {
        int max = this.values.size() - 1;
        StringBuffer buf = new StringBuffer();
        TreeMap treeMap = new TreeMap(this.values);
        Iterator it = treeMap.entrySet().iterator();
        buf.append("{");
        for (int i = 0; i <= max; ++i) {
            Map.Entry e = it.next();
            Object key = e.getKey();
            Object value = e.getValue();
            if (value instanceof IPropertyContainer) {
                buf.append(key + "=" + value.getClass().toString());
            } else {
                buf.append(key + "=" + (value == this ? "(this Map)" : value));
            }
            if (i >= max) continue;
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }

    public int hashCode() {
        return this.values.keySet().hashCode();
    }

    public Object clone() {
        try {
            return ObjectUtils.createCopy(this);
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError();
        }
    }

    protected Map valueClone() {
        if (this.values instanceof SortedStringObjectMap) {
            return (Map)((SortedStringObjectMap)this.values).clone();
        }
        try {
            return (Map)ObjectUtils.createCopy(this.values);
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError();
        }
    }

    @Override
    public void trimToSize() {
        if (this.values instanceof SortedStringObjectMap) {
            ((SortedStringObjectMap)this.values).trimToSize();
        }
    }

    @Override
    public void marshal(Marshaller marshaller) throws IOException {
        marshaller.writeObject(this.values);
    }

    @Override
    public void unmarshal(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        this.values = (Map)unmarshaller.readObject();
    }

    @Override
    public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        new ExternalizeDelegate(this).readExternal(in);
    }

    @Override
    public final void writeExternal(ObjectOutput out) throws IOException {
        new ExternalizeDelegate(this).writeExternal(out);
    }

    public static class InnerEnumeration
    implements Enumeration {
        private final Object[] keys;
        private int index = 0;

        public InnerEnumeration(Object[] keys) {
            this.keys = keys;
        }

        @Override
        public boolean hasMoreElements() {
            if (this.keys == null) {
                return false;
            }
            return this.index < this.keys.length;
        }

        public Object nextElement() {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            Object tmp = this.keys[this.index];
            ++this.index;
            return tmp;
        }
    }

    public static class IdentityStack {
        private ArrayList stack = new ArrayList(3);

        public Object push(Object value) {
            this.stack.add(value);
            return value;
        }

        public Object pop() {
            int size = this.stack.size();
            if (size == 0) {
                return null;
            }
            return this.stack.remove(size - 1);
        }

        public Object get(int i) {
            return this.stack.get(i);
        }

        public int size() {
            return this.stack.size();
        }

        public int search(Object o) {
            int n = this.stack.size();
            for (int i = 0; i < n; ++i) {
                if (this.stack.get(i) != o) continue;
                return i;
            }
            return -1;
        }
    }
}

