/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util;

import com.kingdee.util.DbSequenceImpl;
import com.kingdee.util.UuidException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;

public final class Sequence
implements Serializable,
Comparable {
    private static final long serialVersionUID = -3575277369015448051L;
    private transient long sequenceVal;

    public static Sequence create(Connection cn, String ais) throws UuidException {
        long seqVal = DbSequenceImpl.getSequenceValue(ais, cn);
        return new Sequence(seqVal);
    }

    private Sequence(long seqVal) {
        this.sequenceVal = seqVal;
    }

    public byte[] toByteArray() {
        byte[] array = new byte[8];
        this.toBytes(this.sequenceVal, array, 0);
        return array;
    }

    private void toBytes(long x, byte[] array, int startPos) {
        int bytePos = 8;
        while (--bytePos >= 0) {
            array[startPos + bytePos] = (byte)(x & 0xFFL);
            x >>>= 8;
        }
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeLong(this.sequenceVal);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.sequenceVal = s.readLong();
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(0L);
        out.writeLong(this.sequenceVal);
    }

    public static Sequence read(DataInput in) throws IOException {
        in.readLong();
        return new Sequence(in.readLong());
    }

    public static Sequence read(String id) throws UuidException {
        return Sequence.fromString(id);
    }

    public static Sequence fromString(String name) {
        return new Sequence(Long.decode(name));
    }

    public String toString() {
        return Long.toHexString(this.sequenceVal);
    }

    public int hashCode() {
        return (int)(this.sequenceVal ^ this.sequenceVal >>> 32);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Sequence)) {
            return false;
        }
        Sequence id = (Sequence)obj;
        return this.sequenceVal == id.sequenceVal;
    }

    public int compareTo(Object val) {
        if (val instanceof Sequence) {
            Sequence seqId = (Sequence)val;
            long thisVal = this.sequenceVal;
            long anotherVal = seqId.sequenceVal;
            return thisVal < anotherVal ? -1 : (thisVal == anotherVal ? 0 : 1);
        }
        return -1;
    }
}

