/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util;

import com.kingdee.util.IPUtils;
import com.kingdee.util.UuidException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.SocketException;
import org.apache.log4j.Logger;

public class UuidOld
implements Serializable {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.util.UuidOld");
    private static final long serialVersionUID = 7952004632150713063L;
    public static final int LENGTH = 36;
    private transient long high;
    private transient long low;
    private static int UUID_HOST_LOCK_PORT = 5504;
    private static final int MAX_RETRYS = 1200;
    private static final int INTERVAL_TIME = 100;
    private static ServerSocket lockSocket;
    private static long timeStamp;
    private static long adapterAddress;
    private static int instanceCounter;
    private static final long versionMask = 4096L;
    private static final long reserveMask = -2305843009213693952L;
    private static final long randomMask = 0x1FFFFFFFL;
    private static final char[] hexDigits;

    public static synchronized UuidOld create() throws UuidException {
        int count;
        if (timeStamp == 0L) {
            UuidOld.setTimeStamp();
        }
        if (adapterAddress == 0L) {
            UuidOld.setAdapterAddress();
        }
        UuidOld uuid = new UuidOld();
        long midTime = timeStamp >> 32 & 0xFFFFFFFFL;
        uuid.high = timeStamp << 32 | midTime << 16 & 0xFFFF0000L | 0x1000L | timeStamp >> 48 & 0xFFFL;
        if ((count = instanceCounter++) == 0x1FFFFFFF) {
            instanceCounter = 0;
            UuidOld.setTimeStamp();
        }
        uuid.low = ((long)count & 0x1FFFFFFFL) << 32 | 0xE000000000000000L | adapterAddress;
        return uuid;
    }

    private UuidOld() {
    }

    private UuidOld(long high, long low) {
        this.high = high;
        this.low = low;
    }

    private static void setAdapterAddress() throws UuidException {
        try {
            byte[] addr = IPUtils.getLocleAddress().getAddress();
            int raw = addr[3] & 0xFF | addr[2] << 8 & 0xFF00 | addr[1] << 16 & 0xFF0000 | addr[0] << 24 & 0xFF000000;
            adapterAddress = (long)raw & 0xFFFFFFFFL;
        }
        catch (SocketException e) {
            throw new UuidException("Unexpected failure");
        }
    }

    private static void setTimeStamp() throws UuidException {
        UuidOld.acquireHostLock();
        try {
            long newTime = System.currentTimeMillis();
            if (timeStamp != 0L) {
                if (newTime < timeStamp) {
                    throw new UuidException("Unique identifier clock failure");
                }
                if (newTime == timeStamp) {
                    UuidOld.letClockTick(newTime);
                    newTime = System.currentTimeMillis();
                }
            }
            timeStamp = newTime;
        }
        finally {
            UuidOld.releaseHostLock();
        }
    }

    private static void letClockTick(long curTime) throws UuidException {
        int timeoutCounter = 0;
        long sleepTime = 1L;
        long newTime = System.currentTimeMillis();
        while (newTime == curTime) {
            ++timeoutCounter;
            sleepTime *= 2L;
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (sleepTime > 60000L) {
                throw new UuidException("Unique identifier unexpected failure");
            }
            newTime = System.currentTimeMillis();
        }
    }

    private static void acquireHostLock() throws UuidException {
        String portProperty = null;
        try {
            portProperty = System.getProperty("bluewater.uuid.hostLockPort");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (portProperty != null) {
            try {
                UUID_HOST_LOCK_PORT = Integer.parseInt(portProperty);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int numberOfRetrys = 0;
        while (lockSocket == null) {
            try {
                lockSocket = new ServerSocket(UUID_HOST_LOCK_PORT);
                return;
            }
            catch (BindException e) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (IOException e2) {
                logger.error((Object)("IOException while create serversocket on port[" + UUID_HOST_LOCK_PORT + "]"), (Throwable)e2);
                throw new UuidException("Unique identifier unexpected failure");
            }
            if (numberOfRetrys == 1200) {
                throw new UuidException("Unique identifier lock failure");
            }
            ++numberOfRetrys;
        }
    }

    private static void releaseHostLock() {
        if (lockSocket != null) {
            try {
                lockSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            lockSocket = null;
        }
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof UuidOld) {
            return this.high == ((UuidOld)obj).high && this.low == ((UuidOld)obj).low;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.low << 24) & 0xFF000000 | (int)(this.high >> 20) & 0xFFF000 | (int)(this.low >> 32) & 0xFFF;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(36);
        buf.append(UuidOld.toHexString(this.high >>> 32, 8)).append("-");
        buf.append(UuidOld.toHexString(this.high >>> 16, 4)).append("-");
        buf.append(UuidOld.toHexString(this.high, 4)).append("-");
        buf.append(UuidOld.toHexString(this.low >>> 48, 4)).append("-");
        buf.append(UuidOld.toHexString(this.low, 12));
        return buf.toString();
    }

    private static String toHexString(long x, int chars) {
        char[] buf = new char[chars];
        int charPos = chars;
        while (--charPos >= 0) {
            buf[charPos] = hexDigits[(int)(x & 0xFL)];
            x >>>= 4;
        }
        return new String(buf);
    }

    public byte[] toByteArray() {
        byte[] array = new byte[16];
        this.toBytes(this.high, array, 0);
        this.toBytes(this.low, array, 8);
        return array;
    }

    private void toBytes(long x, byte[] array, int startPos) {
        int bytePos = 8;
        while (--bytePos >= 0) {
            array[startPos + bytePos] = (byte)(x & 0xFFL);
            x >>>= 8;
        }
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeLong(this.high);
        s.writeLong(this.low);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.high = s.readLong();
        this.low = s.readLong();
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.high);
        out.writeLong(this.low);
    }

    public static UuidOld read(DataInput in) throws IOException {
        long high = in.readLong();
        long low = in.readLong();
        return new UuidOld(high, low);
    }

    public static UuidOld read(String id) throws UuidException {
        try {
            String part = id.substring(0, 8);
            long high = 0L;
            high = Long.parseLong(part, 16) << 32;
            part = id.substring(9, 13);
            high |= Long.parseLong(part, 16) << 16;
            part = id.substring(14, 18);
            high |= Long.parseLong(part, 16);
            long low = 0L;
            part = id.substring(19, 23);
            low = Long.parseLong(part, 16) << 48;
            part = id.substring(24, 36);
            UuidOld uuid = new UuidOld(high, low |= Long.parseLong(part, 16));
            return uuid;
        }
        catch (Exception ex) {
            throw new UuidException("Invalid uuid String: '" + id + "'", ex);
        }
    }

    static {
        hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }
}

