/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util;

import com.kingdee.util.ConfigurationException;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.SAXBuilderFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jdom2.xpath.XPath;

public class XMLConfiguration
implements Serializable {
    private Document doc;
    private Element root;
    private File file;
    private URL url;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.util.XMLConfiguration");

    private XMLConfiguration(File file) {
        this.file = file;
    }

    private XMLConfiguration(URL url) {
        this.url = url;
    }

    public static XMLConfiguration getInstance(URL url) throws ConfigurationException {
        if (url == null) {
            throw new ConfigurationException("url is null");
        }
        XMLConfiguration myself = new XMLConfiguration(url);
        myself.load();
        return myself;
    }

    public static XMLConfiguration newInstance(URL url) throws ConfigurationException {
        XMLConfiguration myself = new XMLConfiguration(url);
        myself.createNew();
        return myself;
    }

    public static XMLConfiguration getInstance(File file) throws ConfigurationException {
        if (file == null) {
            throw new ConfigurationException("file is null");
        }
        if (!file.exists()) {
            throw new ConfigurationException("config file " + file.getAbsolutePath() + " not exists.");
        }
        XMLConfiguration myself = new XMLConfiguration(file);
        myself.load();
        return myself;
    }

    public static XMLConfiguration newInstance(File file) throws ConfigurationException {
        XMLConfiguration myself = new XMLConfiguration(file);
        myself.createNew();
        return myself;
    }

    public void addConfigItem(ConfigurationItem item) {
        this.root.addContent((Content)item.el);
    }

    public ConfigurationItem getConfigItem(String name) {
        Element _el = XMLConfiguration.getConfigItemElement(this.root, name);
        if (_el != null) {
            return new ConfigurationItem(_el);
        }
        return null;
    }

    public List getConfigItemList(String name) {
        List _els = XMLConfiguration.getConfigItemElementList(this.root, name);
        if (_els != null) {
            ArrayList<ConfigurationItem> items = new ArrayList<ConfigurationItem>();
            for (int i = 0; i < _els.size(); ++i) {
                Element _el = (Element)_els.get(i);
                ConfigurationItem item = new ConfigurationItem(_el);
                items.add(item);
            }
            return items;
        }
        return null;
    }

    public List getConfigItemList() {
        List _els = this.root.getChildren("configitem");
        ArrayList<ConfigurationItem> children = new ArrayList<ConfigurationItem>();
        for (int i = 0; _els != null && i < _els.size(); ++i) {
            Element _el = (Element)_els.get(i);
            children.add(new ConfigurationItem(_el));
        }
        return children;
    }

    public ConfigurationItem getConfigItemByPath(String path) {
        Element _el = XMLConfiguration.getConfigItemElementByPath(this.root, path);
        if (_el != null) {
            return new ConfigurationItem(_el);
        }
        return null;
    }

    public List getConfigItemListByPath(String name) {
        List _els = XMLConfiguration.getConfigItemElementListByPath(this.root, name);
        if (_els != null) {
            ArrayList<ConfigurationItem> items = new ArrayList<ConfigurationItem>();
            for (int i = 0; i < _els.size(); ++i) {
                Element _el = (Element)_els.get(i);
                ConfigurationItem item = new ConfigurationItem(_el);
                items.add(item);
            }
            return items;
        }
        return null;
    }

    public void removeConfigItem(String name) {
        Element _el = XMLConfiguration.getConfigItemElement(this.root, name);
        if (_el != null) {
            this.root.removeContent((Content)_el);
        }
    }

    public void removeConfigItem(ConfigurationItem item) {
        Element _el = item.el;
        if (_el != null) {
            this.root.removeContent((Content)_el);
        }
    }

    public void removeChildren(String name) {
        List _els = XMLConfiguration.getConfigItemElementList(this.root, name);
        if (_els != null) {
            for (int i = 0; i < _els.size(); ++i) {
                Element _el = (Element)_els.get(i);
                if (_el == null) continue;
                this.root.removeContent((Content)_el);
            }
        }
    }

    public void removeAll() {
        this.root.removeChildren("configitem");
    }

    public void store() throws ConfigurationException {
        this.store(true);
    }

    public void store(boolean createNewFile) throws ConfigurationException {
        Format format = Format.getCompactFormat();
        format.setIndent("   ");
        format.setTextMode(Format.TextMode.TRIM_FULL_WHITE);
        XMLOutputter outputter = new XMLOutputter(format);
        OutputStream os = null;
        try {
            if (this.file != null) {
                if (createNewFile && !this.file.exists()) {
                    this.file.createNewFile();
                }
                os = new FileOutputStream(this.file);
            } else if (this.url != null) {
                os = this.url.openConnection().getOutputStream();
            }
            outputter.output(this.doc, os);
            os.close();
        }
        catch (Exception e) {
            throw new ConfigurationException("store config information failed: " + e.getMessage(), e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e1) {
                    logger.error((Object)"cannot close OutputStream", (Throwable)e1);
                }
            }
        }
    }

    public void reload() throws ConfigurationException {
        try {
            this.root.detach();
            this.root = null;
            this.doc = null;
            if (this.file == null && this.url == null) {
                throw new ConfigurationException("config file not exists.");
            }
            if (this.file != null && this.file.exists()) {
                logger.debug((Object)("reload config file: " + this.file.getAbsolutePath()));
                SAXBuilder builder = SAXBuilderFactory.create();
                this.doc = builder.build(this.file);
            } else if (this.url != null) {
                logger.debug((Object)("reload config from url: " + this.url.getFile()));
                SAXBuilder builder = SAXBuilderFactory.create();
                this.doc = builder.build(this.url);
            } else {
                throw new ConfigurationException("config file not exists");
            }
            this.root = this.doc.getRootElement();
            if (!this.root.getName().equals("config")) {
                throw new ConfigurationException("not a config file,root tag must be 'config'");
            }
        }
        catch (IOException ie) {
            logger.error((Object)ie);
            throw new ConfigurationException("read config error ", ie);
        }
        catch (JDOMException de) {
            throw new ConfigurationException("parse file error ", de);
        }
    }

    private void load() throws ConfigurationException {
        try {
            if (this.file != null && this.file.exists()) {
                logger.debug((Object)("read config file: " + this.file.getAbsolutePath()));
                SAXBuilder builder = SAXBuilderFactory.create();
                this.doc = builder.build(this.file);
            } else if (this.url != null) {
                logger.debug((Object)("read config from url: " + this.url.getFile()));
                SAXBuilder builder = SAXBuilderFactory.create();
                this.doc = builder.build(this.url);
            } else {
                throw new ConfigurationException("config file not exists");
            }
            this.root = this.doc.getRootElement();
            if (!this.root.getName().equals("config")) {
                throw new ConfigurationException("not a config file,root tag must be 'config'");
            }
        }
        catch (IOException ie) {
            logger.error((Object)ie);
            throw new ConfigurationException("read config error ", ie);
        }
        catch (JDOMException de) {
            throw new ConfigurationException("parse file error ", de);
        }
    }

    private void createNew() throws ConfigurationException {
        if (this.file == null && this.url == null) {
            throw new ConfigurationException("config file not exists.");
        }
        if (this.file != null && this.file.exists()) {
            logger.debug((Object)("read config file: " + this.file.getAbsolutePath()));
        } else if (this.url != null) {
            logger.debug((Object)("read config from url: " + this.url.getFile()));
        } else {
            throw new ConfigurationException("config file not exists");
        }
        this.root = new Element("config");
        this.doc = new Document();
        this.doc.setRootElement(this.root);
    }

    public void dump(PrintStream ps) {
        XMLConfiguration.dumpItem(ps, "", this.root);
    }

    static void dumpItem(PrintStream ps, String space, Element _el) {
        if (!_el.getName().equals("config")) {
            ps.println(space + "[configitem]:" + _el.getAttributeValue("name"));
        }
        List _listAttr = _el.getChildren("attribute");
        for (int i = 0; i < _listAttr.size(); ++i) {
            Element __el = (Element)_listAttr.get(i);
            ps.println(space + "  attribute " + __el.getAttributeValue("key") + " = " + __el.getAttributeValue("value"));
        }
        List _listConfigItem = _el.getChildren("configitem");
        for (int i = 0; i < _listConfigItem.size(); ++i) {
            Element __el = (Element)_listConfigItem.get(i);
            XMLConfiguration.dumpItem(ps, space + "    ", __el);
        }
    }

    static Element getAttributeElement(Element el, String key) {
        Element _el = null;
        try {
            _el = (Element)XPath.selectSingleNode((Object)el, (String)("attribute[lower-case(attribute::key)='" + key.toLowerCase() + "']"));
        }
        catch (JDOMException _e) {
            logger.error((Object)"XPath error", (Throwable)_e);
        }
        return _el;
    }

    static Element getConfigItemElement(Element el, String name) {
        Element _el = null;
        try {
            _el = (Element)XPath.selectSingleNode((Object)el, (String)("configitem[lower-case(attribute::name)='" + name.toLowerCase() + "']"));
        }
        catch (JDOMException _e) {
            logger.error((Object)"XPath error", (Throwable)_e);
        }
        return _el;
    }

    static Element getConfigItemElementByPath(Element el, String path) {
        String _name;
        Element _el = null;
        String _path = "";
        StringTokenizer st = new StringTokenizer(path, "/");
        if (st.hasMoreTokens()) {
            _name = st.nextToken();
            _path = _path + "configitem[lower-case(attribute::name)='" + _name.toLowerCase() + "']";
        }
        while (st.hasMoreTokens()) {
            _name = st.nextToken();
            _path = _path + "/configitem[lower-case(attribute::name)='" + _name.toLowerCase() + "']";
        }
        try {
            _el = (Element)XPath.selectSingleNode((Object)el, (String)_path);
        }
        catch (JDOMException _e) {
            logger.error((Object)"XPath error", (Throwable)_e);
        }
        return _el;
    }

    static List getConfigItemElementList(Element el, String name) {
        List _els = null;
        try {
            _els = XPath.selectNodes((Object)el, (String)("configitem[lower-case(attribute::name)='" + name.toLowerCase() + "']"));
        }
        catch (JDOMException _e) {
            logger.error((Object)"XPath error", (Throwable)_e);
        }
        return _els;
    }

    static List getConfigItemElementListByPath(Element el, String path) {
        String _name;
        List _els = null;
        String _path = "";
        StringTokenizer st = new StringTokenizer(path, "/");
        if (st.hasMoreTokens()) {
            _name = st.nextToken();
            _path = _path + "configitem[lower-case(attribute::name)='" + _name.toLowerCase() + "']";
        }
        while (st.hasMoreTokens()) {
            _name = st.nextToken();
            _path = _path + "/configitem[lower-case(attribute::name)='" + _name.toLowerCase() + "']";
        }
        try {
            _els = XPath.selectNodes((Object)el, (String)_path);
        }
        catch (JDOMException _e) {
            logger.error((Object)"XPath error", (Throwable)_e);
        }
        return _els;
    }
}

