/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util.enums;

import com.kingdee.util.enums.DoubleEnum;
import com.kingdee.util.enums.DynamicEnum;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.FloatEnum;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.LongEnum;
import com.kingdee.util.enums.StringEnum;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class EnumUtils
implements Comparable,
Serializable {
    private static Logger logger = Logger.getLogger(EnumUtils.class);

    private EnumUtils() {
    }

    public static Enum getEnum(Class enumClass, String name) {
        return Enum.getEnum(enumClass, name);
    }

    public static String[] getEnumNames(Class enumClass) {
        return Enum.getEnumNames(enumClass);
    }

    public static String[] getEnumAliases(Class enumClass, Locale locale) {
        return Enum.getEnumAliases(enumClass, locale);
    }

    public static String[] getEnumAliases(String enumClassName, Locale locale) {
        if (enumClassName != null) {
            Class<?> enumClass = null;
            try {
                enumClass = Class.forName(enumClassName);
            }
            catch (ClassNotFoundException ex) {
                logger.error((Object)ex, (Throwable)ex);
            }
            if (enumClass != null) {
                return Enum.getEnumAliases(enumClass, locale);
            }
            List enums = Enum.getEnumList(DynamicEnum.DynamicAssist.getFactory().getInstance(enumClassName), true);
            String[] aliases = new String[enums.size()];
            for (int i = 0; i < enums.size(); ++i) {
                Enum _enum = (Enum)enums.get(i);
                aliases[i] = _enum.getAlias(locale);
            }
            return aliases;
        }
        return null;
    }

    public static String[] getEnumAliases(String enumClassName) {
        return EnumUtils.getEnumAliases(enumClassName, null);
    }

    public static String[] getEnumAliases(Class enumClass) {
        return Enum.getEnumAliases(enumClass, null);
    }

    public static IntEnum getEnum(Class enumClass, int value) {
        return (IntEnum)IntEnum.getEnum(enumClass, value);
    }

    public static Map getEnumMap(Class enumClass) {
        return Enum.getEnumMap(enumClass);
    }

    public static List getEnumList(Class enumClass) {
        return Enum.getEnumList(enumClass);
    }

    public static List getEnumList(String enumClassName) {
        if (enumClassName != null) {
            Class<?> enumClass = null;
            try {
                enumClass = Class.forName(enumClassName);
            }
            catch (ClassNotFoundException ex) {
                logger.error((Object)ex, (Throwable)ex);
            }
            if (enumClass != null) {
                return Enum.getEnumList(enumClass);
            }
            return Enum.getEnumList(DynamicEnum.DynamicAssist.getFactory().getInstance(enumClassName), true);
        }
        return null;
    }

    public static Iterator iterator(Class enumClass) {
        return Enum.getEnumList(enumClass).iterator();
    }

    public static FloatEnum getEnum(Class enumClass, float value) {
        return (FloatEnum)FloatEnum.getEnum(enumClass, value);
    }

    public static LongEnum getEnum(Class enumClass, long value) {
        return (LongEnum)LongEnum.getEnum(enumClass, value);
    }

    public static DoubleEnum getEnum(Class enumClass, double value) {
        return (DoubleEnum)DoubleEnum.getEnum(enumClass, value);
    }

    public static StringEnum getEnumByValue(Class enumClass, String value) {
        return (StringEnum)StringEnum.getEnum(enumClass, value);
    }
}

