/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.kscript.debug;

import com.kingdee.bos.kscript.debug.AbstractBreakPoints;
import com.kingdee.bos.kscript.debug.BasicValue;
import com.kingdee.bos.kscript.debug.DebugStopException;
import com.kingdee.bos.kscript.debug.IDebugContext;
import com.kingdee.bos.kscript.debug.IDebugEnv;
import com.kingdee.bos.kscript.debug.IDebugRuntime;
import com.kingdee.bos.kscript.debug.IDebugTracer;
import com.kingdee.bos.kscript.debug.IStackElement;
import com.kingdee.bos.kscript.debug.IValue;
import com.kingdee.bos.kscript.debug.StackElement;
import com.kingdee.bos.kscript.debug.UniqueKey;
import com.kingdee.bos.kscript.dom.CodeObject;
import com.kingdee.bos.kscript.dom.Function;
import com.kingdee.bos.kscript.dom.expr.MethodInvokeExpr;
import com.kingdee.bos.kscript.parser.Position;
import com.kingdee.bos.kscript.parser.Source;
import com.kingdee.bos.kscript.runtime.Interpreter;
import com.kingdee.bos.kscript.runtime.InterpreterException;
import com.kingdee.bos.kscript.runtime.ToString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class DebugTracer
implements IDebugTracer,
IDebugContext {
    static final Logger logger = Logger.getLogger(DebugTracer.class);
    public final Interpreter interpreter;
    private volatile int state = 1;
    private ArrayList stack = new ArrayList();
    private final IDebugEnv env;
    public static final Object LOCAL_IDENTIFIER = new Object[0];
    private volatile boolean isFirstCode = true;
    private Source mainSource = null;
    private Source currentSource = null;
    private CodeObject currentCode = null;
    private Map currentContext = null;
    private volatile boolean debugWaiting = false;
    private Object returnValue = null;
    private Thread runningThread = null;
    private Object runningThreadName = null;
    private int debug_command = 0;
    private volatile boolean debugStoped = false;
    private Source lastPausedSource = null;
    private int lastPausedLine = 0;
    private int lastPausedStackSize = 0;
    private volatile boolean hasRunOutLastPaused = false;
    private volatile int stepCount = 0;
    private Interpreter noDebug = null;
    private HashMap tagMap = new HashMap();
    private final Object key = UniqueKey.next();

    @Override
    public IDebugRuntime getEnv() {
        return this.env;
    }

    public DebugTracer(IDebugEnv env, Interpreter interpreter) {
        this.env = env;
        this.interpreter = interpreter;
    }

    @Override
    public synchronized boolean isDebugWaiting() {
        return this.debugWaiting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(int state) {
        DebugTracer debugTracer = this;
        synchronized (debugTracer) {
            if (this.state == state) {
                return;
            }
            this.state = state;
        }
        this.env.notifyStateChanged(this);
    }

    synchronized void enterDebugWaiting(Source source, CodeObject code, Map context) {
        this.validState(2);
        this.setState(4);
        this.currentCode = code;
        this.currentSource = source;
        if (source == null && code != null && code.position != null) {
            this.currentSource = code.position.source;
        }
        this.currentContext = context;
        this.debugWaiting = true;
        boolean waitingLogged = false;
        if (this.currentContext != null) {
            this.currentContext.put("__jvm_stack", new Exception("StackTrace"));
        }
        try {
            while (!this.debugStoped && this.debugWaiting && !this.env.isTerminated()) {
                if (!waitingLogged) {
                    waitingLogged = true;
                    logger.debug((Object)"enter debug waiting mode...");
                }
                this.wait();
            }
        }
        catch (InterruptedException ex) {
            this.setState(8);
            throw new DebugStopException(ex);
        }
        finally {
            if (this.currentContext != null) {
                this.currentContext.remove("__jvm_stack");
            }
            if (waitingLogged) {
                logger.debug((Object)"leave debug waiting mode.");
            }
        }
        this.setState(2);
        if (this.debug_command == 5) {
            this.debug_command = 0;
            throw new DebugStopException("manual stoped by debuger.");
        }
    }

    @Override
    public void stopDebug() {
        this.debugStoped = true;
        this.leaveDebugWaiting();
    }

    synchronized void leaveDebugWaiting() {
        this.debugWaiting = false;
        this.notify();
    }

    @Override
    public synchronized Source getMainSource() {
        return this.mainSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evalEnter(Interpreter interpreter, Source source, Map context) {
        if (this.debugStoped) {
            return;
        }
        boolean isMain = false;
        DebugTracer debugTracer = this;
        synchronized (debugTracer) {
            this.runningThread = Thread.currentThread();
            this.runningThreadName = String.valueOf(this.runningThread);
            this.currentSource = source;
            this.setState(2);
            if (this.stack.size() == 0) {
                this.clearStates();
                this.debug_command = 0;
                this.mainSource = source;
                this.isFirstCode = true;
                isMain = true;
            }
        }
        if (isMain) {
            this.env.evalStart(this, source, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object evalLeave(Interpreter interpreter, Source source, Map context, Object returnValue) {
        if (this.debugStoped) {
            return returnValue;
        }
        boolean isFinished = false;
        DebugTracer debugTracer = this;
        synchronized (debugTracer) {
            this.returnValue = returnValue;
            if (returnValue != null && returnValue instanceof DebugStopException || this.stack.size() == 0) {
                this.setState(8);
                this.stack.clear();
                this.debug_command = 0;
                this.clearStates();
                isFinished = true;
            }
            this.currentSource = null;
        }
        if (isFinished) {
            this.env.evalFinish(this, source, context, returnValue);
        }
        return returnValue;
    }

    @Override
    public synchronized IValue getReturnValue() {
        return BasicValue.valueOf(this.returnValue, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evalFuncEnter(Interpreter interpreter, Function funcObj, MethodInvokeExpr methodInvokeExpr, Map context) {
        if (this.debugStoped) {
            return;
        }
        StackElement e = new StackElement(funcObj, methodInvokeExpr, context);
        DebugTracer debugTracer = this;
        synchronized (debugTracer) {
            this.stack.add(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Object evalFuncLeave(Interpreter interpreter, Function funcObj, MethodInvokeExpr methodInvokeExpr, Map context, Object returnValue) {
        if (this.debugStoped) {
            return returnValue;
        }
        DebugTracer debugTracer = this;
        synchronized (debugTracer) {
            StackElement e = (StackElement)this.stack.remove(this.stack.size() - 1);
            assert (e.function == funcObj && e.invokeExpr == methodInvokeExpr);
        }
        return returnValue;
    }

    private void setPausedPosition(Position pos) {
        this.lastPausedSource = pos.source;
        this.lastPausedLine = pos.beginLine;
        this.lastPausedStackSize = this.stack.size();
        this.hasRunOutLastPaused = false;
    }

    private boolean isStepOver(Position pos) {
        if (this.lastPausedSource == null) {
            return true;
        }
        return this.stack.size() <= this.lastPausedStackSize;
    }

    private boolean isStepInto(Position pos) {
        return true;
    }

    private boolean isStepOut(Position pos) {
        if (this.lastPausedSource == null) {
            return false;
        }
        return this.stack.size() < this.lastPausedStackSize;
    }

    private boolean isRunOutLastPaused(Position pos) {
        if (this.hasRunOutLastPaused) {
            return true;
        }
        if (this.lastPausedSource == null) {
            return true;
        }
        if (this.stack.size() != this.lastPausedStackSize) {
            return true;
        }
        if (pos.beginLine != this.lastPausedLine) {
            return true;
        }
        return !this.lastPausedSource.equals(pos.source);
    }

    private void clearStates() {
        this.lastPausedSource = null;
    }

    @Override
    public synchronized Source getCurrentSource() {
        return this.currentSource;
    }

    @Override
    public void evalCode(Interpreter interpreter, CodeObject code, Map context) {
        this.evalCode(code, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evalError(Interpreter interpreter, CodeObject code, Map context, Throwable err) {
        if (this.state == 1) {
            return;
        }
        DebugTracer debugTracer = this;
        synchronized (debugTracer) {
            if (err instanceof InterpreterException) {
                Throwable err1 = ((InterpreterException)((Object)err)).getOrigException();
                if (err1 == null) {
                    err1 = ((InterpreterException)((Object)err)).getCause();
                }
                if (err1 != null) {
                    err = err1;
                }
            }
            this.returnValue = err;
            this.currentCode = code;
            this.currentContext = context;
            context.put("__eval_error", err);
        }
        this.setState(1);
    }

    @Override
    public int getStepTickCount() {
        return this.stepCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evalCode(CodeObject code, Map context) {
        if (this.debugStoped) {
            return;
        }
        ++this.stepCount;
        Position pos = code.position;
        if (pos == null || !pos.isValidPosition()) {
            return;
        }
        if (!this.env.contansDebugSource(pos.source.getKey())) {
            return;
        }
        this.currentCode = code;
        this.currentContext = context;
        this.currentSource = pos.source;
        boolean firstCode = this.isFirstCode;
        this.isFirstCode = false;
        DebugTracer debugTracer = this;
        synchronized (debugTracer) {
            AbstractBreakPoints bps;
            this.currentSource = pos.source;
            this.hasRunOutLastPaused = this.isRunOutLastPaused(pos);
            if (this.hasRunOutLastPaused) {
                if (this.debug_command == 3 && this.isStepOver(pos) || this.debug_command == 2 && this.isStepOut(pos) || this.debug_command == 1 && this.isStepInto(pos) || this.debug_command == 4) {
                    this.debug_command = 0;
                    this.pauseCode(code, context);
                    return;
                }
                if (this.debug_command == 5) {
                    this.debug_command = 0;
                    this.currentContext = null;
                    this.currentCode = null;
                    this.currentSource = null;
                    this.setState(8);
                    throw new DebugStopException("manual stoped by debuger.");
                }
            }
            if ((bps = this.env.getBreakPoints(pos.source.getKey())) != null && bps.needBreak(this, !this.hasRunOutLastPaused, code, context, firstCode)) {
                this.pauseCode(code, context);
                return;
            }
        }
    }

    private void pauseCode(CodeObject code, Map context) {
        this.setPausedPosition(code.position);
        this.enterDebugWaiting(null, code, context);
    }

    @Override
    public synchronized IValue evalNoDebug(String expr) throws Exception {
        if (this.noDebug == null) {
            this.noDebug = new Interpreter(this.interpreter.getBOSContext(), false);
        }
        return BasicValue.valueOf(this.noDebug.eval(expr, this.currentContext, false), null);
    }

    public void validState(int state) {
        if ((state & this.state) == 0) {
            throw new Error("invalid running state.");
        }
    }

    public void validContextAvailable() {
        this.validState(13);
    }

    @Override
    public synchronized IValue getContext() {
        this.validContextAvailable();
        return BasicValue.valueOf(this.currentContext, Map.class);
    }

    @Override
    public synchronized Position getCurrentPosition() {
        if (this.currentCode == null) {
            return null;
        }
        Position p = this.currentCode.position;
        if (p.isValidPosition()) {
            return p;
        }
        return null;
    }

    public synchronized Interpreter getInterpreter() {
        return this.interpreter;
    }

    @Override
    public synchronized IValue getRunningThread() {
        return BasicValue.valueOf(this.runningThreadName, null);
    }

    @Override
    public synchronized IStackElement[] getStack() {
        this.validContextAvailable();
        if (this.stack.size() == 0) {
            return StackElement.EMPTY;
        }
        IStackElement[] ar = new IStackElement[this.stack.size()];
        this.stack.toArray(ar);
        return ar;
    }

    @Override
    public synchronized int getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getTag(Object key) {
        HashMap hashMap = this.tagMap;
        synchronized (hashMap) {
            return this.tagMap.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setTag(Object key, Object value) {
        HashMap hashMap = this.tagMap;
        synchronized (hashMap) {
            this.tagMap.put(key, value);
        }
    }

    @Override
    public synchronized void pause() {
        if (this.runningThread.equals(Thread.currentThread()) && this.currentCode != null && this.currentContext != null) {
            this.pauseCode(this.currentCode, this.currentContext);
        } else {
            this.debug_command = 4;
        }
    }

    @Override
    public synchronized void resume() {
        this.validState(12);
        this.leaveDebugWaiting();
    }

    @Override
    public synchronized void stepInto() {
        if (this.state == 4 || this.state == 2) {
            this.debug_command = 1;
            this.leaveDebugWaiting();
        }
    }

    @Override
    public synchronized void stepOut() {
        if (this.state == 4 || this.state == 2) {
            this.debug_command = 2;
            this.leaveDebugWaiting();
        }
    }

    @Override
    public synchronized void stepOver() {
        if (this.state == 4 || this.state == 2) {
            this.debug_command = 3;
            this.leaveDebugWaiting();
        }
    }

    @Override
    public synchronized void stop() {
        this.debug_command = 5;
        this.leaveDebugWaiting();
    }

    @Override
    public Object getKey() {
        return this.key;
    }

    @Override
    public boolean isDebugEnabled() {
        if (this.debugStoped) {
            return false;
        }
        if (this.mainSource == null) {
            return false;
        }
        return this.env.contansDebugSource(this.mainSource.getKey());
    }

    @Override
    public Object getLocalIdentifier() {
        return LOCAL_IDENTIFIER;
    }

    @Override
    public void print(Object msg) {
        this.env.debugOutput(this, ToString.toString(msg));
    }

    @Override
    public void println(Object msg) {
        this.print(ToString.toString(msg) + "\r\n");
    }

    @Override
    public void println() {
        this.print("\r\n");
    }
}

