/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.kscript.dom.expr;

import com.kingdee.bos.kscript.dom.CodeObject;
import com.kingdee.bos.kscript.dom.expr.ExprType;
import com.kingdee.bos.kscript.dom.expr.IntExpr;
import com.kingdee.bos.kscript.dom.expr.NullExpr;
import com.kingdee.bos.kscript.dom.expr.StringExpr;
import com.kingdee.bos.kscript.parser.Position;
import java.math.BigDecimal;
import java.sql.Timestamp;

public abstract class CodeExpr
extends CodeObject {
    public int exprType;

    public abstract Class getExprClass();

    public abstract void setExprClass(Class var1);

    protected CodeExpr(int exprType) {
        this(null, exprType);
    }

    protected CodeExpr(Position pos, int exprType) {
        super(pos);
        this.exprType = exprType;
    }

    public String typename() {
        return ExprType.typename(this.exprType);
    }

    @Override
    public void output(StringBuffer buffer, String prefix) {
        buffer.append(prefix);
        buffer.append("SqlExpr:");
        buffer.append(this.typename());
        buffer.append("\n");
    }

    public static CodeExpr toExpr(int value) {
        return new IntExpr(null, Integer.toString(value));
    }

    public static CodeExpr toExpr(long value) {
        throw new UnsupportedOperationException("");
    }

    public static CodeExpr toExpr(double value) {
        return new IntExpr(null, Double.toString(value));
    }

    public static CodeExpr toExpr(Timestamp value) {
        if (value == null) {
            return NullExpr.instance;
        }
        throw new UnsupportedOperationException("");
    }

    public static CodeExpr toExpr(byte[] value) {
        if (value == null) {
            return NullExpr.instance;
        }
        throw new UnsupportedOperationException("");
    }

    public static CodeExpr toExpr(BigDecimal value) {
        if (value == null) {
            return NullExpr.instance;
        }
        throw new UnsupportedOperationException("");
    }

    public static CodeExpr toCharExpr(String value) {
        if (value == null) {
            return NullExpr.instance;
        }
        return new StringExpr(null, value);
    }

    public static CodeExpr toNCharExpr(String value) {
        if (value == null) {
            return NullExpr.instance;
        }
        return new StringExpr(null, value);
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        this.output(buff);
        return buff.toString();
    }

    public abstract void output(StringBuffer var1);
}

