/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.kscript.debug.ui;

import com.kingdee.bos.kscript.debug.IDebugRuntime;
import com.kingdee.bos.kscript.debug.ui.DebugManager;
import com.kingdee.bos.kscript.debug.ui.DebugUI;
import com.kingdee.bos.kscript.debug.ui.Props;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class RemoteDialog
extends JDialog {
    private JLabel _rpcUrl = new JLabel("RPC URL:");
    private JLabel _address = new JLabel("DebugServer Address:");
    private JLabel _startPort = new JLabel("Start Listen Port:");
    private JLabel _endPort = new JLabel("End Listen Port:");
    private JTextField rpcUrl = new JTextField(DebugUI.props.get("remote.rpcUrl"));
    private JTextField address = new JTextField(DebugUI.props.get("remote.address"));
    private JTextField startPort = new JTextField(DebugUI.props.get("remote.startPort"));
    private JTextField endPort = new JTextField(DebugUI.props.get("remote.endPort"));
    private JButton btnOK = new JButton("Connect");
    private JButton btnCancel = new JButton("Cancel");
    private JCheckBox rpcEnabled = new JCheckBox("RPC Controller", DebugManager.isRpcSupported() && DebugUI.props.getBoolean("remote.rpcEnabled"));
    DebugUI main;
    private static final int ALIGN_Y = 30;
    private static final int ALIGN_LEFT = 20;
    private static final int ALIGN_HEIGHT = 24;
    private static final int LABEL_WIDTH = 150;
    private static final int TEXT_WIDTH = 300;
    private static final int BUTTON_HEIGHT = 30;
    private static final int BUTTON_WIDTH = 120;

    public RemoteDialog(DebugUI owner) {
        super(owner, "Connect Remote Debug Server", true);
        this.rpcEnabled.setEnabled(DebugManager.isRpcSupported());
        this.main = owner;
        super.setResizable(false);
        this.getContentPane().setLayout(null);
        this.getContentPane().add(this.rpcUrl);
        this.getContentPane().add(this.address);
        this.getContentPane().add(this.startPort);
        this.getContentPane().add(this.endPort);
        this.getContentPane().add(this.btnOK);
        this.getContentPane().add(this.btnCancel);
        this.getContentPane().add(this.rpcEnabled);
        this.getContentPane().add(this._rpcUrl);
        this.getContentPane().add(this._address);
        this.getContentPane().add(this._startPort);
        this.getContentPane().add(this._endPort);
        int y = 10;
        this.rpcEnabled.setBounds(20, y, 450, 24);
        this.setInputBounds(this._rpcUrl, this.rpcUrl, y += 30);
        this.setInputBounds(this._startPort, this.startPort, y += 30);
        this.setInputBounds(this._endPort, this.endPort, y += 30);
        this.setInputBounds(this._address, this.address, y += 30);
        this.setButtonBounds(this.btnOK, 100, y += 40);
        this.setButtonBounds(this.btnCancel, 300, y);
        this.pack();
        this.setBounds(DebugUI.props.getInt("remote.x"), DebugUI.props.getInt("remote.y"), 500, 280);
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RemoteDialog.this.cancel();
            }
        });
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RemoteDialog.this.connect();
            }
        });
        this.rpcEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RemoteDialog.this.enableButtons(true);
            }
        });
        this.enableButtons(false);
        DebugUI.props.traceComponent("remotedialog", this);
    }

    private void setButtonBounds(JButton b, int x, int y) {
        b.setBounds(x, y, 120, 30);
    }

    private void setInputBounds(JLabel l, JTextField f, int y) {
        l.setBounds(20, y, 150, 24);
        f.setBounds(170, y, 300, 24);
    }

    private void enableButtons(boolean save) {
        if (save) {
            Props props = DebugUI.props;
            props.set("remote.rpcUrl", this.rpcUrl.getText(), false);
            props.set("remote.address", this.address.getText(), false);
            props.set("remote.startPort", this.startPort.getText(), false);
            props.set("remote.endPort", this.endPort.getText(), false);
            props.set("remote.rpcEnabled", "" + this.rpcEnabled.isSelected());
            props.save();
        }
        this.rpcUrl.setEnabled(this.rpcEnabled.isSelected());
        this.startPort.setEnabled(this.rpcEnabled.isSelected());
        this.endPort.setEnabled(this.rpcEnabled.isSelected());
    }

    private void cancel() {
        this.setVisible(false);
    }

    private boolean isNull(JTextField f) {
        String s = f.getText();
        return s == null || s.trim().length() == 0;
    }

    private String getText(JTextField f) {
        String s = f.getText();
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    private int getInt(JTextField f) {
        if (this.isNull(f)) {
            return 0;
        }
        return Integer.parseInt(this.getText(f));
    }

    private void connect() {
        this.enableButtons(true);
        try {
            IDebugRuntime r = null;
            if (this.rpcEnabled.isSelected()) {
                if (this.isNull(this.rpcUrl)) {
                    this.main.alert("Rpc url is empty.");
                    return;
                }
                String url = this.getText(this.rpcUrl);
                int start = this.getInt(this.startPort);
                int end = this.getInt(this.endPort);
                String addr = this.getText(this.address);
                r = this.main.getDebugManager().connectRpcRemote(url, start, end, addr);
            } else {
                if (this.isNull(this.address)) {
                    this.main.alert("Address is empty");
                    return;
                }
                String addr = this.getText(this.address);
                r = this.main.getDebugManager().connectRemote(addr);
            }
            this.setVisible(false);
            this.main.alert("Connect Succeeded", "Remote Debug Server '" + DebugManager.getDebugRuntimeName(r) + "' connected.", false);
        }
        catch (Exception ex) {
            this.main.handleException(ex);
        }
    }
}

