/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.kscript.debug.ui;

import com.kingdee.bos.kscript.debug.IStackElement;
import com.kingdee.bos.kscript.debug.ui.ChangedListener;
import com.kingdee.bos.kscript.debug.ui.ConnectionsPanel;
import com.kingdee.bos.kscript.debug.ui.DebugPanel;
import com.kingdee.bos.kscript.debug.ui.ScriptPanel;
import com.kingdee.bos.kscript.parser.Position;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class StackPanel
extends JTabbedPane {
    public DebugPanel debugPanel;
    public final JList list = new JList();
    public final ConnectionsPanel connections;
    private Element[] currentData = null;
    private int scriptPanelIndex = 1;

    public StackPanel(DebugPanel debugPanel) {
        this.debugPanel = debugPanel;
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                StackPanel.this.valueChanged();
            }
        });
        JScrollPane sp = new JScrollPane(this.list);
        this.addTab("stack", sp);
        this.connections = new ConnectionsPanel(debugPanel.uiMain);
        this.addTab("connections", this.connections);
        debugPanel.uiMain.debugManager.addChangedListener(new ChangedListener(){

            @Override
            public void notifyChanged(Object source, Object args) {
                StackPanel.this.setSelectedIndex(1);
            }
        });
        this.addScriptPanel();
    }

    private void valueChanged() {
        Element e = (Element)this.list.getSelectedValue();
        if (e != null && e.pos.isValidPosition()) {
            this.debugPanel.sourcePanel.dropToPosition(e.pos);
        }
    }

    public Component getComponent() {
        return this;
    }

    public void notifyChanged() {
        ArrayList<Element> ar = new ArrayList<Element>();
        if (this.debugPanel.debug != null && (this.debugPanel.debug.getState() == 4 || this.debugPanel.debug.getState() == 1)) {
            ar.add(new Element(this.debugPanel.debug.getCurrentPosition(), true));
            IStackElement[] stack = this.debugPanel.debug.getStack();
            for (int i = stack.length - 1; i >= 0; --i) {
                ar.add(new Element(stack[i].getPosition(), false));
            }
        }
        this.currentData = new Element[ar.size()];
        ar.toArray(this.currentData);
        this.list.setListData(this.currentData);
        if (this.list.getSelectedIndex() < 0 && ar.size() != 0) {
            this.list.setSelectedIndex(0);
        }
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (!(this.getComponentAt(i) instanceof ScriptPanel)) continue;
            ScriptPanel sp = (ScriptPanel)this.getComponentAt(i);
            sp.enableButtons();
        }
    }

    public void selectPosition(Position pos) {
        if (pos == null || !pos.isValidPosition() || this.currentData == null) {
            return;
        }
        this.setSelectedIndex(0);
        for (int i = 0; i < this.currentData.length; ++i) {
            Element e = this.currentData[i];
            if (!e.pos.source.getKey().equals(pos.source.getKey()) || e.pos.beginLine != pos.beginLine) continue;
            this.list.setSelectedIndex(i);
            return;
        }
    }

    public ScriptPanel addScriptPanel() {
        String title = "KS#" + this.scriptPanelIndex++;
        ScriptPanel panel = new ScriptPanel(title, this, this.debugPanel);
        this.addTab(title, panel);
        this.setSelectedComponent(panel);
        return panel;
    }

    public int getScriptPanelCount() {
        return this.getTabCount() - 2;
    }

    class Element {
        Position pos;
        boolean isCurrent;

        public Element(Position pos, boolean isCurrent) {
            this.pos = pos;
            this.isCurrent = isCurrent;
        }

        public String toString() {
            return "line=" + this.pos.beginLine + " : " + (this.isCurrent ? this.pos.source.getLine(this.pos.beginLine) : this.pos.getSourceText());
        }
    }
}

