/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.search.biz;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.search.biz.BOSSearchBizPluginManager;
import com.kingdee.bos.search.biz.IBOSSearchBizPlugin;
import com.kingdee.bos.search.lucene.LuceneEngine;
import com.kingdee.bos.search.lucene.bean.SearchBizCfg;
import com.kingdee.bos.search.lucene.bean.TempBizId;
import com.kingdee.bos.search.msic.Tool;
import java.util.List;
import java.util.Map;

public class BOSSearchBizPlugin
implements IBOSSearchBizPlugin {
    @Override
    public boolean getRealBizId(TempBizId tempBiz) {
        String bosType = null;
        bosType = tempBiz.getBizId().endsWith("WFWKITEM") || tempBiz.getBizId().endsWith("WFPCINST") ? "WORKFLOW" : Tool.bosType(tempBiz.getBizId());
        IBOSSearchBizPlugin plugin = BOSSearchBizPluginManager.get(tempBiz.getCtx().getAIS(), bosType);
        if (plugin != null) {
            return plugin.getRealBizId(tempBiz);
        }
        return true;
    }

    @Override
    public SelectorItemCollection getPropsToIndex(Context ctx, String bosType) {
        IBOSSearchBizPlugin plugin = BOSSearchBizPluginManager.get(ctx.getAIS(), bosType);
        if (plugin != null) {
            return plugin.getPropsToIndex(ctx, bosType);
        }
        List<SearchBizCfg> cfgs = LuceneEngine.getEngine(ctx.getAIS()).getBizCfgs();
        for (SearchBizCfg cfg : cfgs) {
            if (!cfg.getBosType().equals(bosType)) continue;
            return cfg.getSelectColl();
        }
        return new SelectorItemCollection();
    }

    @Override
    public boolean checkIfAddToIndex(Context ctx, String bosType, String billId) throws BOSException {
        IBOSSearchBizPlugin plugin = BOSSearchBizPluginManager.get(ctx.getAIS(), bosType);
        if (plugin != null) {
            return plugin.checkIfAddToIndex(ctx, bosType, billId);
        }
        return true;
    }

    @Override
    public Map<String, String> getCustomDocFieldMap(Context ctx, String bosType, String billId) {
        IBOSSearchBizPlugin plugin = BOSSearchBizPluginManager.get(ctx.getAIS(), bosType);
        if (plugin != null) {
            return plugin.getCustomDocFieldMap(ctx, bosType, billId);
        }
        return null;
    }
}

