/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.search.biz;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.search.biz.DocBuilderTool;
import com.kingdee.bos.search.biz.IDocumentBuilder;
import com.kingdee.bos.search.lucene.IndexUtil;
import com.kingdee.bos.search.lucene.bean.FieldBizType;
import com.kingdee.bos.search.lucene.bean.FieldMapInfo;
import com.kingdee.bos.search.lucene.bean.LuceneBizId;
import com.kingdee.bos.search.msic.Tool;
import com.kingdee.util.PropertyContainer;
import com.kingdee.util.enums.DynamicEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;

public class DefaultDocumentBuilder
implements IDocumentBuilder {
    private Context ctx;
    private String bosType;
    private SelectorItemCollection propsAsQuery = new SelectorItemCollection();
    private final SelectorItemCollection DEFAULT_SELECTOR = new SelectorItemCollection();

    public DefaultDocumentBuilder(Context ctx, String bosType) {
        this.bosType = bosType;
        this.ctx = ctx;
        this.DEFAULT_SELECTOR.add("*");
    }

    public void reload() {
    }

    @Override
    public List<Document> buildDocs(LuceneBizId biz) throws Exception {
        String boId = biz.getBizId();
        ArrayList<FieldMapInfo> filedMapList = new ArrayList<FieldMapInfo>();
        this.buildFiledMap(this.ctx, filedMapList, boId, null, false, Tool.bosType(boId));
        List<Document> documents = DocBuilderTool.buildDocs(this.ctx, this.bosType, boId, filedMapList, this.propsAsQuery);
        return documents;
    }

    private void buildFiledMap(Context ctx, List<FieldMapInfo> filedMapList, String ownerId, String entryId, boolean isEntry, String bosType) throws Exception {
        String curentId = isEntry ? entryId : ownerId;
        PropertyCollection props = IndexUtil.getEntityProps(ctx, bosType);
        Object o = IndexUtil.boVal(ctx, curentId, this.DEFAULT_SELECTOR);
        String billName = ((PropertyContainer)o).getString("name");
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        PropertyContainer container = (PropertyContainer)o;
        for (int i = 0; i < props.size(); ++i) {
            PropertyInfo prop = props.get(i);
            String name = prop.getName();
            Object val = container.get(name);
            if (val == null) continue;
            if (prop instanceof OwnPropertyInfo) {
                String enumPk;
                DynamicEnum dyEnum;
                OwnPropertyInfo ownProp = (OwnPropertyInfo)prop;
                if (ownProp.getDataType() == DataType.ENUM && (dyEnum = DynamicEnum.getEnum((String)(enumPk = ownProp.getMetaDataRef()), (Object)val.toString())) != null) {
                    val = dyEnum.getAlias();
                }
                if (val == null) continue;
                String valStr = this.doSomeCut(val.toString());
                fieldMap.put(name, valStr);
                continue;
            }
            if (!(prop instanceof LinkPropertyInfo)) continue;
            if (val instanceof AbstractObjectCollection) {
                AbstractObjectCollection collects = (AbstractObjectCollection)val;
                int size = collects.size();
                if (size > 500) {
                    size = 500;
                }
                for (int j = 0; j < size; ++j) {
                    IObjectValue objVal = collects.getObject(j);
                    if (objVal == null) continue;
                    String eid = ((PropertyContainer)objVal).get("id").toString();
                    this.buildFiledMap(ctx, filedMapList, ownerId, eid, true, objVal.getBOSType().toString());
                }
                continue;
            }
            Object id = ((PropertyContainer)val).get("id");
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add("name");
            selectors.add("number");
            Object val2 = IndexUtil.boVal(ctx, id.toString(), selectors);
            Object nameVal = ((PropertyContainer)val2).get("name");
            Object numVal = ((PropertyContainer)val2).get("number");
            String valInfo = FieldBizType.$F7$.name() + ":" + id + ";" + nameVal + ";" + numVal;
            fieldMap.put(name, valInfo);
        }
        FieldMapInfo fieldMapInfo = new FieldMapInfo(ownerId, entryId, isEntry, bosType, billName, fieldMap);
        filedMapList.add(fieldMapInfo);
    }

    @Override
    public Map<String, Object> buildMap(LuceneBizId biz) throws Exception {
        return null;
    }

    private String doSomeCut(String orginal) {
        try {
            Float f = Float.valueOf(orginal);
            if ((float)f.intValue() == f.floatValue()) {
                return f.intValue() + "";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return orginal;
    }
}

