/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.search.db;

import com.kingdee.bos.search.db.EasConnectionProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;

public class DbClient {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int update(String dc, String sql) throws SQLException {
        Connection cn = EasConnectionProvider.getConnection(dc);
        Statement smt = null;
        try {
            smt = cn.createStatement();
            int n = smt.executeUpdate(sql);
            return n;
        }
        finally {
            DbClient.close(smt);
            DbClient.close(cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int update(String dc, String sql, int[] types, Object[] params) throws SQLException {
        int n;
        Connection cn = EasConnectionProvider.getConnection(dc);
        PreparedStatement psm = null;
        try {
            psm = DbClient.prepareStatement(sql, types, params, cn);
            n = psm.executeUpdate();
        }
        catch (Throwable throwable) {
            DbClient.close(psm);
            DbClient.close(cn);
            throw throwable;
        }
        DbClient.close(psm);
        DbClient.close(cn);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList query(String dc, String sql) throws SQLException, IOException {
        Connection cn = EasConnectionProvider.getConnection(dc);
        Statement smt = null;
        try {
            smt = cn.createStatement();
            ResultSet rs = smt.executeQuery(sql);
            ArrayList arrayList = DbClient.toArray(rs);
            return arrayList;
        }
        finally {
            DbClient.close(smt);
            DbClient.close(cn);
        }
    }

    public static ArrayList query(String dc, String sql, int[] types, Object[] params) throws SQLException, IOException {
        ArrayList arrayList;
        Connection cn = EasConnectionProvider.getConnection(dc);
        PreparedStatement psm = null;
        try {
            psm = DbClient.prepareStatement(sql, types, params, cn);
            ResultSet rs = psm.executeQuery();
            arrayList = DbClient.toArray(rs);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbClient.close(psm);
                DbClient.close(cn);
                throw throwable;
            }
        }
        DbClient.close(psm);
        DbClient.close(cn);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList toArray(ResultSet rs) throws SQLException, IOException {
        ResultSetMetaData meta = rs.getMetaData();
        String[] names = new String[meta.getColumnCount() + 1];
        for (int i = 1; i <= meta.getColumnCount(); ++i) {
            names[i] = meta.getColumnName(i).toLowerCase();
        }
        ArrayList list = new ArrayList();
        try {
            DbClient.resultSet2Array(rs, names, list);
        }
        finally {
            DbClient.close(rs);
        }
        return list;
    }

    private static void resultSet2Array(ResultSet rs, String[] names, ArrayList list) throws SQLException, IOException {
        while (rs.next()) {
            HashMap<String, Object> item = new HashMap<String, Object>();
            for (int i = 1; i < names.length; ++i) {
                Object v = rs.getObject(i);
                if ((v = DbClient.convert(v)) == null) continue;
                item.put(names[i], v);
            }
            list.add(item);
        }
    }

    private static Object convert(Object o) throws SQLException, IOException {
        if (o instanceof Clob) {
            return DbClient.clobToString((Clob)o);
        }
        if (o instanceof Blob) {
            return DbClient.fromBlob((Blob)o);
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object fromBlob(Blob blob) throws SQLException, IOException {
        if (blob == null) {
            return null;
        }
        int len = (int)blob.length();
        if (len == 0) {
            return null;
        }
        byte[] bytes = new byte[len];
        try (InputStream is = blob.getBinaryStream();){
            is.read(bytes);
        }
        return bytes;
    }

    private static Object clobToString(Clob clob) throws SQLException, IOException {
        StringBuffer sb = new StringBuffer();
        try (Reader r = clob.getCharacterStream();){
            int ch22;
            while ((ch22 = r.read()) >= 0) {
                sb.append((char)ch22);
            }
            String ch22 = sb.toString();
            return ch22;
        }
    }

    private static PreparedStatement prepareStatement(String sql, int[] types, Object[] params, Connection cn) throws SQLException {
        PreparedStatement psm = cn.prepareStatement(sql);
        for (int i = 0; i < types.length; ++i) {
            if (params[i] != null) {
                psm.setObject(i + 1, params[i], types[i]);
                continue;
            }
            psm.setNull(i + 1, types[i]);
        }
        return psm;
    }

    public static void close(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void close(Connection cn) {
        try {
            EasConnectionProvider.releaseConnection(cn);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void close(Statement smt) {
        try {
            if (smt != null) {
                smt.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void close(ResultSet rs, Statement smt, Connection cn) {
        DbClient.close(rs);
        DbClient.close(smt);
        DbClient.close(cn);
    }
}

