/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.search.easLog;

import com.kingdee.bos.search.easLog.LogEventInfo;
import com.kingdee.bos.search.easLog.SFormatter;
import com.kingdee.bos.search.easLog.ServerInfoMap;
import com.kingdee.bos.search.lucene.SolrSearchService;
import com.kingdee.bos.search.msic.SerializationUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.LogRecord;
import org.apache.log4j.spi.LoggingEvent;

public class KSearchAppender {
    public static KSearchAppender INS = new KSearchAppender();
    private String IP;
    private String server;
    private ExecutorService executorService = Executors.newFixedThreadPool(3);
    private BlockingQueue<LogEventInfo> bizIdQueue = new LinkedBlockingQueue<LogEventInfo>();

    private KSearchAppender() {
        try {
            this.IP = ServerInfoMap.getLocalIP();
            this.server = ServerInfoMap.getLocalServer();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.init();
    }

    public void append(LogEventInfo eventInfo) {
        if (this.bizIdQueue.size() > 1000) {
            return;
        }
        if (eventInfo.getEvent() != null) {
            eventInfo.getEvent().getThreadName();
        }
        this.bizIdQueue.offer(eventInfo);
    }

    private void init() {
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            ArrayList<LogEventInfo> logs = new ArrayList<LogEventInfo>();
                            LogEventInfo eInfo = (LogEventInfo)KSearchAppender.this.bizIdQueue.take();
                            logs.add(eInfo);
                            int n = KSearchAppender.this.bizIdQueue.size();
                            if (n > 5) {
                                for (int i = 0; i < n; ++i) {
                                    eInfo = (LogEventInfo)KSearchAppender.this.bizIdQueue.take();
                                    logs.add(eInfo);
                                }
                            }
                            List<Map<String, Object>> maps = this.toMaps(logs);
                            SolrSearchService.INS.addEasLog(maps);
                        }
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    break;
                }
            }

            private List<Map<String, Object>> toMaps(List<LogEventInfo> logs) {
                ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>();
                for (LogEventInfo eInfo : logs) {
                    Timestamp ts;
                    String[] str;
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("ip_str", KSearchAppender.this.IP);
                    map.put("server_str", KSearchAppender.this.server);
                    map.put("trace_id", eInfo.getTraceId());
                    String fileName = eInfo.getLogFile();
                    if (fileName.contains("/") && (fileName = (str = fileName.split("/"))[str.length - 1]).contains(".")) {
                        str = fileName.split("\\.");
                        fileName = str[0];
                    }
                    map.put("logFile", fileName);
                    LoggingEvent e = eInfo.getEvent();
                    if (e != null) {
                        String msg;
                        map.put("level_str", e.getLevel().toString());
                        String string = msg = e.getMessage() != null ? e.getMessage().toString() : "   ";
                        if (e.getThrowableInformation() != null) {
                            Throwable t = e.getThrowableInformation().getThrowable();
                            msg = msg + SerializationUtil.dump(t);
                        }
                        map.put("message", "[" + e.getThreadName() + "]" + msg);
                        ts = new Timestamp(e.getStartTime());
                        map.put("timestamp", ts.toString());
                        map.put("loggerName", e.getLoggerName());
                        map.put("codeLocation", e.getLocationInformation().fullInfo);
                    } else {
                        LogRecord record = eInfo.getRecord();
                        map.put("level_str", record.getLevel().getName());
                        ts = new Timestamp(record.getMillis());
                        map.put("timestamp", ts.toString());
                        map.put("message_str", SFormatter.INS.format(record));
                    }
                    maps.add(map);
                }
                return maps;
            }
        });
    }
}

