/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.search.easLog;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.Context;
import com.kingdee.bos.search.lucene.SolrSearchService;
import com.kingdee.bos.search.lucene.bean.SearchParam;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LogSearchAgent {
    public static List<Map<String, Object>> search(Context ctx, Map<String, String> map) throws Exception {
        SearchParam param = LogSearchAgent.searchParam(map);
        return SolrSearchService.INS.search4List(param);
    }

    public static String getSearchJson(Context ctx, Map<String, String> map) throws Exception {
        return JSON.toJSONString(LogSearchAgent.search(ctx, map));
    }

    private static SearchParam searchParam(Map<String, String> map) {
        String timestamp = null;
        HashMap<String, String> filter = new HashMap<String, String>();
        if (map.get("startTime") != null) {
            timestamp = "[" + LogSearchAgent.wrapperTimestamp(map.get("startTime")) + " TO ";
            timestamp = map.get("endTime") != null ? timestamp + LogSearchAgent.wrapperTimestamp(map.get("startTime")) + "]" : timestamp + "*]";
            filter.put("timestamp", timestamp);
            map.remove("startTime");
            map.remove("endTime");
        }
        if (map.get("logFile") != null) {
            filter.put("logFile", map.get("logFile"));
            map.remove("logFile");
        }
        String rows = map.get("rows");
        int top = 0;
        if (rows != null) {
            top = Integer.valueOf(rows);
            map.remove("rows");
        }
        String sort = map.get("sort");
        map.remove("sort");
        if (map.size() == 0) {
            map.put("*", "*");
        }
        SearchParam param = new SearchParam("EASLOG", "easlog", map, filter);
        param.setSortFiled("timestamp");
        if (sort != null && sort.equals("desc")) {
            param.setDesc(true);
        }
        if (top > 0) {
            param.setTop(top);
        }
        if (map.get("message") != null) {
            param.setHighlightField("message");
        }
        return param;
    }

    private static String wrapperTimestamp(String ts) {
        ts = ts.replace(" ", "T");
        ts = ts + "Z";
        return ts;
    }
}

