/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.search.easLog;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class SFormatter
extends Formatter {
    public static SFormatter INS = new SFormatter();
    private DateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private FieldPosition fp = new FieldPosition(0);
    private Date dat = new Date();
    private StringBuffer sb = new StringBuffer(256);
    private static final String LINE_SEP = System.getProperty("line.separator");

    @Override
    public synchronized String format(LogRecord record) {
        this.sb.setLength(0);
        this.dat.setTime(record.getMillis());
        this.formatter.format(this.dat, this.sb, this.fp);
        this.sb.append(" ");
        this.sb.append(record.getLevel().getLocalizedName());
        this.sb.append(" [");
        this.sb.append(record.getLoggerName());
        this.sb.append("-Thread ");
        this.sb.append(record.getThreadID());
        this.sb.append("] ");
        this.sb.append(this.formatMessage(record));
        this.sb.append(LINE_SEP);
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                this.sb.append(sw.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.sb.toString();
    }
}

