/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.search.easLog;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.rpc.io.loadbalance.IRPCServer;
import com.kingdee.bos.rpc.io.loadbalance.RPCServerView;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServerInfoMap {
    private static Map<String, List<String>> map = new HashMap<String, List<String>>();
    private static String IP;
    private static String SERVER_NAME;

    public static String getLocalIP() {
        if (IP == null) {
            try {
                IP = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return IP;
    }

    public static String getLocalServer() {
        String path;
        if (SERVER_NAME == null && (path = System.getProperty("EAS_INSTANCE_HOME")) != null && path.contains("/")) {
            String[] temp = path.split("/");
            SERVER_NAME = temp[temp.length - 1];
        }
        return SERVER_NAME;
    }

    public static Map<String, List<String>> get() {
        if (map.size() == 0) {
            RPCServerView sv = RPCServerView.getLast();
            if (sv == null) {
                ArrayList<String> ls = new ArrayList<String>();
                ls.add(ServerInfoMap.getLocalServer());
                map.put(ServerInfoMap.getLocalIP(), ls);
            } else {
                IRPCServer[] ss = sv.getServers();
                for (int i = 0; i < ss.length; ++i) {
                    IRPCServer s = ss[i];
                    String url = s.getUrl();
                    String serverName = s.getName();
                    String ip = url.split("//")[1].split(":")[0];
                    if (map.get(ip) == null) {
                        ArrayList<String> ls = new ArrayList<String>();
                        ls.add(serverName);
                        map.put(ip, ls);
                        continue;
                    }
                    map.get(ip).add(serverName);
                }
            }
        }
        return map;
    }

    public static String getJson() {
        return JSON.toJSONString(ServerInfoMap.get());
    }
}

