/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.search.example;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.search.log.Logger;
import com.kingdee.bos.search.log.LoggerFactory;
import com.kingdee.bos.search.lucene.IndexService;
import com.kingdee.bos.search.lucene.SolrSearchService;
import com.kingdee.bos.search.lucene.bean.DeleteParam;
import com.kingdee.bos.search.lucene.bean.KSField;
import com.kingdee.bos.search.lucene.bean.PageResult;
import com.kingdee.bos.search.lucene.bean.SearchParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BizSearchExample {
    protected static final Logger logger = LoggerFactory.REF.get().getLogger(BizSearchExample.class);
    public static final String BOSTYPE = "4A44F49F";

    public static List<Map<String, Object>> search(Context ctx, String searchVal, String userId) throws Exception {
        HashMap<String, String> condition = new HashMap<String, String>();
        condition.put("creator", userId);
        SearchParam param = new SearchParam(ctx.getAIS(), BOSTYPE, null, searchVal, condition);
        return SolrSearchService.INS.search4List(param);
    }

    public static void buildIndex(Context ctx, String billId) {
        try {
            IndexService.INS.submit(ctx, BOSTYPE, billId);
        }
        catch (Exception e) {
            logger.error("BizSearchExample buildIndex error ", e);
        }
    }

    public static String json() {
        ArrayList<KSField> fs = new ArrayList<KSField>();
        KSField f = new KSField("number", "\u7f16\u7801", DataType.STRING.getName(), false, false, true, true);
        fs.add(f);
        f = new KSField("creator", "\u7528\u6237", DataType.STRING.getName(), true, false, true, true);
        fs.add(f);
        f = new KSField("cause", "\u4e8b\u7531", DataType.STRING.getName(), false, false, true, true);
        fs.add(f);
        f = new KSField("entries.purpose", "\u5206\u5f55\u7528\u9014", DataType.STRING.getName(), false, true, true, true);
        fs.add(f);
        f = new KSField("amount", "\u5408\u8ba1\u91d1\u989d", DataType.INTEGER.getName(), false, false, true, true);
        fs.add(f);
        return JSON.toJSONString(fs);
    }

    public void pageSearchDemo() {
        HashMap<String, String> filter = new HashMap<String, String>();
        String dc = "EASLOG";
        String bosType = "scmlog";
        HashMap sMap = Maps.newHashMap();
        sMap.put("name", "\u5f20\u4e09");
        SearchParam searchParam = new SearchParam(dc, bosType, sMap, filter);
        searchParam.setSortFiled("sortNum");
        searchParam.setDesc(true);
        searchParam.setNotFilterFields(true);
        searchParam.setStart(1);
        searchParam.setTop(3);
        PageResult pageResult = SolrSearchService.INS.pageSearch(searchParam);
        List<Map<String, Object>> dataList = pageResult.getDataList();
        Long count = pageResult.getCount();
    }

    public void delSolrDocDemo() throws Exception {
        DeleteParam deleteParam = new DeleteParam();
        deleteParam.setDc("EASLOG");
        deleteParam.setBosType("scmlog");
        deleteParam.setQueryStr("field1:value1 AND field2:value2");
        SolrSearchService.INS.deleteDoc(deleteParam);
    }
}

