/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.search.log;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LoggerWriter {
    private static final long serialVersionUID = 1L;
    private static String dir = null;
    private static int maxSize = 0;
    private static String logFile;
    private static OutputStream os;
    private static int index;
    private static int byte_count;
    private static final char[] chars;

    static void init() {
        LoggerWriter.initLoggerDir();
        LoggerWriter.initLoggerMaxSize();
    }

    private static void initLoggerMaxSize() {
        maxSize = 0x500000;
    }

    private static void initLoggerDir() {
        String path = System.getProperty("EAS_INSTANCE_HOME");
        dir = path + File.separator + "logs" + File.separator + "Ksearch" + File.separator;
        File f = new File(dir);
        f.mkdirs();
    }

    static void output(String message) {
        if (dir == null) {
            return;
        }
        OutputStream out = LoggerWriter.getOutputStream();
        if (out != null) {
            try {
                byte[] bytes = message.getBytes("UTF-8");
                out.write(bytes);
                out.write(13);
                out.write(10);
                LoggerWriter.closeOutputStream(bytes);
            }
            finally {
                return;
            }
        }
    }

    private static void closeOutputStream(byte[] bytes) {
        if ((byte_count += bytes.length + 2) > maxSize) {
            try {
                os.close();
                os = null;
                byte_count = 0;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static OutputStream getOutputStream() {
        if (os == null) {
            if (++index >= chars.length) {
                index = 0;
            }
            try {
                logFile = dir + "log." + chars[index] + ".txt";
                File file = new File(logFile);
                os = new FileOutputStream(file);
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }
        return os;
    }

    public static String getLoggerDir() {
        return dir;
    }

    public static String getLogFile() {
        return logFile;
    }

    static {
        index = -1;
        byte_count = 0;
        chars = "0123456789".toCharArray();
    }
}

