/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.search.lucene;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.search.log.Logger;
import com.kingdee.bos.search.log.LoggerFactory;
import com.kingdee.bos.search.lucene.LuceneEngine;
import com.kingdee.bos.search.lucene.bean.IndexBizState;
import com.kingdee.bos.search.lucene.bean.SearchApp;
import com.kingdee.bos.search.msic.Tool;
import com.kingdee.bos.service.job.util.SQL;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IndexAcquirer
implements Runnable {
    protected static final Logger logger = LoggerFactory.REF.get().getLogger(IndexAcquirer.class);
    public Map<String, List<String>> dcFileIdList = new HashMap<String, List<String>>();
    private String dc;
    private String bizUnit;
    private int MAX_IDS = 100;
    private int SLEEP_TIME = 100;
    private String dirName;

    public IndexAcquirer(String dc, String bizUnit) {
        this.dc = dc;
        this.bizUnit = bizUnit;
    }

    public void doAcquire() {
        this.acquire(this.dc);
    }

    private int acquire(String dc) {
        try {
            String sql = "select top " + this.MAX_IDS + " fbillId,fbostype from " + Tool.getBizLuceneTable(this.bizUnit) + " where fnode =? and fdc = ? and fdirName is null and fop='" + (Object)((Object)IndexBizState.OP_TO_ADD) + "'";
            ArrayList list = SQL.executeQuery((String)dc, (String)sql, (int[])new int[]{12, 12}, (Object[])new Object[]{LuceneEngine.getNode().getID(), dc});
            int i = 0;
            for (Object o : list) {
                String billId = (String)((Map)o).get("fbillid");
                String bostype = (String)((Map)o).get("fbostype");
                this.tryAcquire(dc, billId, bostype);
                ++i;
            }
            return i;
        }
        catch (Exception e) {
            logger.error("IndexAcquirer error in (" + dc + "):", e);
            return 0;
        }
    }

    private boolean tryAcquire(String dc, String billId, String bostype) {
        String sql = "update " + Tool.getBizLuceneTable(this.bizUnit) + " set fdirName=? where fdirName is null and fbillId =? and fnode = ?";
        String dirName = this.getDirName(dc, bostype);
        try {
            int effect = SQL.executeUpdate((String)dc, (String)sql, (int[])new int[]{12, 12, 12}, (Object[])new Object[]{dirName, billId, LuceneEngine.getNode().getID()});
            return effect > 0;
        }
        catch (BOSException e) {
            logger.error("\u66f4\u65b0id{" + billId + "}\u7684\u7d22\u5f15\u76ee\u5f55\u5931\u8d25." + (Object)((Object)e));
            return false;
        }
    }

    private String getDirName(String dc, String bostype) {
        if (LuceneEngine.getEngine(dc).searchApp() == SearchApp.EASLocal) {
            File[] dirs = LuceneEngine.getEngine(dc).getDcFiles().get(dc + File.separator + bostype);
            return dirs[0].getName();
        }
        return LuceneEngine.getServerName();
    }

    @Override
    public void run() {
        do {
            this.doAcquire();
            try {
                Thread.sleep(this.SLEEP_TIME);
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage(), e);
            }
        } while (LuceneEngine.getEngine(this.dc).isRunning());
    }
}

