/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.search.lucene;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.search.lucene.bean.LuceneBizId;
import com.kingdee.bos.search.msic.Tool;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.util.PropertyContainer;
import com.kingdee.util.enums.DynamicEnum;
import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;

public class IndexUtil {
    public static IObjectValue createObjectValueByBoId_Dynamic(String boid, Context ctx, SelectorItemCollection selectors) throws BOSException {
        ObjectUuidPK pk = new ObjectUuidPK(boid);
        IObjectValue model = null;
        IDynamicObject dynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
        model = dynamicObject.getValue(pk.getObjectType(), (IObjectPK)pk, selectors);
        return model;
    }

    public static EntityObjectInfo getEntityObj(Context ctx, String bosType) {
        BOSObjectType type = BOSObjectType.create((String)bosType);
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        return loader.getEntity(type);
    }

    public static PropertyCollection getEntityProps(Context ctx, String bosType) {
        EntityObjectInfo info = IndexUtil.getEntityObj(ctx, bosType);
        return info.getInheritedNoDuplicatedPropertiesRuntime();
    }

    public static Object boVal(Context ctx, String boId, SelectorItemCollection selectors) throws Exception {
        ObjectUuidPK pk = new ObjectUuidPK(boId);
        IObjectValue model = null;
        try {
            IDynamicObject dynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
            model = dynamicObject.getValue(pk.getObjectType(), (IObjectPK)pk, selectors);
        }
        catch (DataAccessException e) {
            throw new WfException((Throwable)e, true);
        }
        catch (BOSException e) {
            throw new WfException((Throwable)e, true);
        }
        return model;
    }

    public static LuceneBizId toLuceneBizId(Object obj) {
        Map m = (Map)obj;
        String dc = (String)m.get("fdc");
        String bizId = (String)m.get("fbillid");
        String node = (String)m.get("fnode");
        String dirName = (String)m.get("fdirname");
        String op = (String)m.get("fop");
        long optime = ((Timestamp)m.get("foptime")).getTime();
        String bosType = (String)m.get("fbostype");
        return new LuceneBizId(bizId, dc, dirName, node, op, optime, bosType);
    }

    public static String generateWK(String bizKey, String dirName) {
        return bizKey + File.separator + dirName;
    }

    public static List<Field> getQueryConditionValue(Context ctx, SelectorItemCollection sc, String boId) throws Exception {
        if (sc == null || sc.size() == 0) {
            return new ArrayList<Field>();
        }
        EntityObjectInfo entityObj = IndexUtil.getEntityObj(ctx, Tool.bosType(boId));
        PropertyContainer container = (PropertyContainer)IndexUtil.boVal(ctx, boId, sc);
        ArrayList<Field> fields = new ArrayList<Field>();
        for (int i = 0; i < sc.size(); ++i) {
            Object id;
            Object linkProp;
            String name = sc.get(i).getPropertyName();
            PropertyInfo prop = entityObj.getPropertyByNameRuntime(name);
            Object val = null;
            if (prop instanceof OwnPropertyInfo) {
                OwnPropertyInfo ownProp = (OwnPropertyInfo)prop;
                if (ownProp.getDataType() == DataType.ENUM) {
                    String enumPk = ownProp.getMetaDataRef();
                    DynamicEnum dyEnum = DynamicEnum.getEnum((String)enumPk, (Object)(val = container.get(name)).toString());
                    if (dyEnum != null) {
                        val = dyEnum.getAlias();
                    } else {
                        dyEnum = DynamicEnum.getEnum((String)enumPk, (Object)val);
                        if (dyEnum != null) {
                            val = dyEnum.getAlias();
                        }
                    }
                } else {
                    val = container.get(name);
                }
                if (val == null) continue;
                TextField f = new TextField(name, val.toString(), Field.Store.YES);
                fields.add((Field)f);
                continue;
            }
            if (!(prop instanceof LinkPropertyInfo) || (linkProp = container.get(name)) == null || linkProp instanceof AbstractObjectCollection || (id = ((PropertyContainer)linkProp).get("id")) == null) continue;
            StringField f = new StringField(name, id.toString(), Field.Store.YES);
            fields.add((Field)f);
        }
        return fields;
    }

    public static long sizeOfDirectory(File directory) {
        long size = 0L;
        File[] files = directory.listFiles();
        if (files == null) {
            return 0L;
        }
        for (File file : files) {
            size += IndexUtil.sizeOf(file);
        }
        return size;
    }

    public static long sizeOf(File file) {
        if (file.isDirectory()) {
            return IndexUtil.sizeOfDirectory(file);
        }
        return file.length();
    }

    public static String transferUnit(long capacity) {
        String transferCapacity = "";
        transferCapacity = (int)(capacity / 1024L) == 0 ? capacity + "B" : ((int)(capacity / 0x100000L) == 0 ? (float)Math.round((float)capacity / 1024.0f * 10.0f) / 10.0f + "KB" : ((int)(capacity / 0x40000000L) == 0 ? (float)Math.round((float)capacity / 1048576.0f * 10.0f) / 10.0f + "MB" : (float)Math.round((float)capacity / 1.0737418E9f * 10.0f) / 10.0f + "G"));
        return transferCapacity;
    }
}

