/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.search.lucene;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.search.biz.DocBuilderManager;
import com.kingdee.bos.search.biz.IDocumentBuilder;
import com.kingdee.bos.search.ksconnection.KSearchConnection;
import com.kingdee.bos.search.log.Logger;
import com.kingdee.bos.search.log.LoggerFactory;
import com.kingdee.bos.search.lucene.IndexUtil;
import com.kingdee.bos.search.lucene.LuceneEngine;
import com.kingdee.bos.search.lucene.bean.IndexBizState;
import com.kingdee.bos.search.lucene.bean.LuceneBizId;
import com.kingdee.bos.search.lucene.bean.SearchApp;
import com.kingdee.bos.search.msic.Tool;
import com.kingdee.bos.service.job.util.SQL;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class IndexWorker
implements Runnable {
    protected static final Logger logger = LoggerFactory.REF.get().getLogger(IndexWorker.class);
    private CountDownLatch latch;
    private String dc;
    private String dirName;
    private LinkedList<LuceneBizId> queue;
    private String bizUnit;
    private LuceneEngine engine;

    public IndexWorker(CountDownLatch latch, String dc, String dirName, LinkedList<LuceneBizId> queue, String bizUnit) {
        this.dc = dc;
        this.dirName = dirName;
        this.queue = queue;
        this.latch = latch;
        this.bizUnit = bizUnit;
        this.engine = LuceneEngine.getEngine(dc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.latch.getCount() == 0L) {
                return;
            }
            HashSet<String> keySet = new HashSet<String>();
            while (this.queue.size() > 0) {
                LuceneBizId biz = this.queue.removeFirst();
                String bizKey = biz.getBosType();
                boolean success = this.doLuceneOp(biz);
                if (!success) continue;
                this.resetState(biz);
                keySet.add(bizKey);
            }
            this.commit(keySet);
        }
        catch (Throwable e) {
            logger.error("IndexWorker error", e);
        }
        finally {
            this.latch.countDown();
        }
    }

    private void commit(Set<String> keySet) throws IOException {
        if (this.engine.searchApp() != SearchApp.EASLocal) {
            return;
        }
        for (String key : keySet) {
            this.engine.getWriter(key, this.dc, this.dirName).commit();
            this.engine.getUpdater(this.dc).update(IndexUtil.generateWK(this.dc + File.separator + key, this.dirName));
        }
    }

    private void resetState(LuceneBizId biz) throws BOSException {
        String sql = "update " + Tool.getBizLuceneTable(this.bizUnit) + "  set fop = '" + (Object)((Object)IndexBizState.OP_DO_NOTHING) + "',foptime = ? where fbillId = ? and fnode= ? and fdc = ?";
        SQL.executeUpdate((String)this.dc, (String)sql, (int[])new int[]{93, 12, 12, 12}, (Object[])new Object[]{Tool.now(), biz.getBizId(), biz.getNode(), this.dc});
    }

    private boolean doLuceneOp(LuceneBizId biz) {
        IndexBizState op = IndexBizState.valueOf(biz.getOp());
        try {
            if (IndexBizState.OP_TO_ADD == op) {
                this.add(biz);
            } else if (IndexBizState.OP_TO_UPDATE == op) {
                this.update(biz);
            } else if (IndexBizState.OP_TO_DELETE_NOW == op) {
                this.delete(biz);
            } else if (IndexBizState.OP_TO_DELETE_LATER == op) {
                this.delete(biz);
            }
        }
        catch (Exception e) {
            logger.error("doLuceneOp " + (Object)((Object)op) + " failed,and bizId=" + biz.getBizId() + "...", e);
            return false;
        }
        return true;
    }

    private void delete(LuceneBizId biz) throws Exception {
        int i = this.engine.dataRepository().remove(this.dc, this.bizUnit, biz.getBizId());
        if (i > 0) {
            this.deleteDoc(biz);
        }
    }

    private void deleteDoc(LuceneBizId biz) throws IOException {
        if (this.engine.searchApp() == SearchApp.EASLocal) {
            IndexWriter writer = this.engine.getWriter(biz.getBosType(), this.dc, this.dirName);
            TermQuery termBiz = new TermQuery(new Term("id", biz.getBizId()));
            writer.deleteDocuments(new Query[]{termBiz});
        } else {
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(biz.getBizId());
            KSearchConnection conn = null;
            try {
                conn = this.engine.getKSConnection(this.dc, biz.getBosType());
                conn.deleteDocs(this.dc, biz.getBosType(), ids);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            finally {
                try {
                    this.engine.returnKSConnection(this.dc, biz.getBosType(), conn);
                }
                catch (Exception e) {
                    logger.error("reuturnKSConnection fail", e);
                }
            }
        }
    }

    private void add(LuceneBizId biz) throws Exception, IOException {
        String bosType = biz.getBosType();
        IDocumentBuilder docBuilder = DocBuilderManager.get(this.dc, bosType);
        if (docBuilder == null) {
            throw new Exception("\u5355\u636e{" + bosType + "}\u672a\u6ce8\u518c\u5168\u6587\u68c0\u7d22\u670d\u52a1");
        }
        if (this.engine.searchApp() == SearchApp.EASLocal) {
            List<Document> docs = docBuilder.buildDocs(biz);
            IndexWriter writer = this.engine.getWriter(biz.getBosType(), this.dc, this.dirName);
            for (Document doc : docs) {
                writer.addDocument((Iterable)doc);
            }
        } else {
            Map<String, Object> map = docBuilder.buildMap(biz);
            KSearchConnection conn = null;
            try {
                conn = this.engine.getKSConnection(this.dc, biz.getBosType());
                if (map == null) {
                    List<Document> docs = docBuilder.buildDocs(biz);
                    conn.updateDoc(this.dc, bosType, docs);
                }
                conn.updateDoc(this.dc, bosType, map);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            finally {
                try {
                    this.engine.returnKSConnection(this.dc, biz.getBosType(), conn);
                }
                catch (Exception e) {
                    logger.error("reuturnKSConnection fail", e);
                }
            }
        }
    }

    private void update(LuceneBizId biz) throws Exception {
        this.deleteDoc(biz);
        this.add(biz);
    }
}

