/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.search.lucene;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.search.log.Logger;
import com.kingdee.bos.search.log.LoggerFactory;
import com.kingdee.bos.search.lucene.LuceneSendMsgAgent;
import com.kingdee.bos.search.lucene.bean.LuceneMsg;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.Locale;

public class LuceneSendMsg {
    protected static final Logger logger = LoggerFactory.REF.get().getLogger(LuceneSendMsg.class);
    private Message message = MessageFactory.newMessage();
    private LuceneMsg luceneMsg = null;
    private Context ctx = null;
    private String adminID = "00000000-0000-0000-0000-00000000000013B7DE7F";

    public LuceneSendMsg(LuceneMsg luceneMsg, Context ctx) {
        this.luceneMsg = luceneMsg;
        this.ctx = ctx;
    }

    public void send() {
        this.fillMessage();
        LuceneSendMsgAgent.getInstance().onMessage(this.message);
    }

    private void fillMessage() {
        this.message.setStringHeader("domain", this.luceneMsg.getDomain());
        this.message.setStringHeader("receiver", this.getReceiver(this.ctx));
        this.message.setStringHeader("databaseCenter", this.ctx.getAIS());
        this.message.setStringHeader("solution", this.ctx.getSolution());
        this.message.setStringHeader("category", this.luceneMsg.getCategory());
        this.message.setStringHeader("sourceID", "");
        this.message.setIntHeader("type", this.luceneMsg.getType());
        this.message.setIntHeader("bizType", this.luceneMsg.getBizType());
        this.message.setIntHeader("priority", this.luceneMsg.getPriority());
        this.message.setIntHeader("sourceStatus", this.luceneMsg.getSourceStatus());
        this.message.setLocaleStringHeader("title", this.luceneMsg.getTitle(), new Locale("l1"));
        this.message.setLocaleStringHeader("title", this.luceneMsg.getTitle(), new Locale("l2"));
        this.message.setLocaleStringHeader("title", this.luceneMsg.getTitle(), new Locale("l3"));
        this.message.setLocaleStringHeader("body", this.luceneMsg.getBody(), new Locale("l1"));
        this.message.setLocaleStringHeader("body", this.luceneMsg.getBody(), new Locale("l2"));
        this.message.setLocaleStringHeader("body", this.luceneMsg.getBody(), new Locale("l3"));
        this.message.setLocaleStringHeader("sender", this.luceneMsg.getSender(), new Locale("l1"));
        this.message.setLocaleStringHeader("sender", this.luceneMsg.getSender(), new Locale("l2"));
        this.message.setLocaleStringHeader("sender", this.luceneMsg.getSender(), new Locale("l3"));
        if (this.luceneMsg.isSendMobile()) {
            this.message.setBooleanHeader("isSendMobile", true);
        } else if (this.luceneMsg.isSendMobile()) {
            this.message.setBooleanHeader("isSendEmail", true);
        } else {
            this.message.setBooleanHeader("isSendCommon", true);
        }
    }

    private String getReceiver(Context ctx) {
        String receiver = this.adminID;
        String sql = "select fnotifier from t_lucene_baseConfig";
        try {
            String notifiers;
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rowSet.next() && !StringUtils.isEmpty((String)(notifiers = rowSet.getString("fnotifier")))) {
                receiver = this.transferUser(notifiers, ctx);
            }
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), e);
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), e);
        }
        return receiver;
    }

    private String transferUser(String notifiers, Context ctx) throws BOSException, SQLException {
        String[] notifierArray = notifiers.split(",");
        StringBuffer receiver = new StringBuffer();
        StringBuffer filter = new StringBuffer();
        for (int i = 0; i < notifierArray.length; ++i) {
            filter.append("'").append(notifierArray[i]).append("'");
            if (i >= notifierArray.length - 1) continue;
            filter.append(",");
        }
        String sql = "select u.fid from t_pm_user u inner join t_bd_person p on u.fpersonid =  p.fid where p.fid in (" + filter + ")";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        while (rowSet.next()) {
            receiver.append(rowSet.getString("fid")).append(";");
        }
        if (receiver.indexOf(";") != -1) {
            receiver.append(this.adminID);
        } else {
            receiver.append(this.adminID);
        }
        return receiver.toString();
    }
}

