/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.search.lucene;

import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.MessageListener;
import com.kingdee.bos.service.message.agent.BOSMessageService;
import com.kingdee.bos.service.message.agent.ListenerInfo;
import com.kingdee.bos.service.message.agent.ListenerManager;

public class LuceneSendMsgAgent {
    private static LuceneSendMsgAgent instance = new LuceneSendMsgAgent();
    private ListenerManager listeners;

    public static LuceneSendMsgAgent getInstance() {
        return instance;
    }

    protected LuceneSendMsgAgent() {
        this.init();
    }

    private void dispatch(Message bosMsg) {
        String listenerDomain = null;
        String senderDomain = bosMsg.getDomian();
        for (int i = 0; i < this.listeners.size(); ++i) {
            ListenerInfo listenInfo = this.listeners.get(i);
            listenerDomain = listenInfo.doamin;
            if (listenerDomain == null || senderDomain == null) continue;
            MessageListener listener = listenInfo.listener;
            if (listenerDomain.length() == 0) {
                this.newMsgListenerThread(listener, bosMsg);
                continue;
            }
            if (!senderDomain.startsWith(listenerDomain)) continue;
            if (senderDomain.length() == listenerDomain.length()) {
                this.newMsgListenerThread(listener, bosMsg);
                continue;
            }
            if (senderDomain.charAt(listenerDomain.length()) != '.') continue;
            this.newMsgListenerThread(listener, bosMsg);
        }
    }

    private void newMsgListenerThread(final MessageListener listener, final Message bosMsg) {
        if (BOSMessageService.getMessageTheadPool() != null) {
            BOSMessageService.getMessageTheadPool().startThread(new Runnable(){

                @Override
                public void run() {
                    listener.onMessage(bosMsg);
                }
            });
        } else {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    listener.onMessage(bosMsg);
                }
            }).start();
        }
    }

    public int onMessage(Message message) {
        this.dispatch(message);
        return 1;
    }

    public void init() {
        this.listeners = new ListenerManager();
        this.listeners.loadListeners();
    }
}

