/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.search.lucene;

import com.kingdee.bos.search.log.Logger;
import com.kingdee.bos.search.log.LoggerFactory;
import com.kingdee.bos.search.lucene.IndexSearchProvider;
import com.kingdee.bos.search.lucene.IndexSearchProviderFactory;
import com.kingdee.bos.search.lucene.LuceneEngine;
import java.io.File;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class SearchUpdater
implements Runnable {
    protected static final Logger logger = LoggerFactory.REF.get().getLogger(SearchUpdater.class);
    private String dc;
    private final int SLEEP_TIME = 50;
    private BlockingQueue<String> queue = new LinkedBlockingQueue<String>();
    private boolean isInited = false;
    public static final String STOP = "STOP_MY_SELF";

    public SearchUpdater(String dc) {
        this.dc = dc;
    }

    public void update(String dirKey) {
        this.queue.offer(dirKey);
    }

    public void init() {
        for (Map.Entry<String, File[]> e : LuceneEngine.getEngine(this.dc).getDcFiles().entrySet()) {
            File[] fs;
            String k = e.getKey();
            for (File f : fs = e.getValue()) {
                this.update(k + File.separator + f.getName());
            }
        }
        this.isInited = true;
    }

    @Override
    public void run() {
        do {
            try {
                if (!this.isInited) {
                    this.init();
                }
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                logger.error("SearchUpdater error:" + e);
            }
            this.doUpdateIndexSearch();
        } while (LuceneEngine.getEngine(this.dc).isRunning());
    }

    private void doUpdateIndexSearch() {
        try {
            String key = this.queue.take();
            if (key.equals(STOP)) {
                return;
            }
            IndexSearchProvider provider = LuceneEngine.getEngine(this.dc).getSearchProviders().get(key);
            if (provider == null) {
                String path = LuceneEngine.getIndexRootDir() + File.separator + key;
                File dir = new File(path);
                if (dir.list().length == 1 && dir.listFiles()[0].length() == 0L) {
                    this.queue.put(key);
                    return;
                }
                provider = IndexSearchProviderFactory.getIndexSearchProvider(new File(path), key);
                LuceneEngine.getEngine(this.dc).getSearchProviders().put(key, provider);
            } else {
                provider.refreshIfNeed();
            }
        }
        catch (Exception e) {
            logger.error("SearchUpdater error:", e);
        }
    }
}

