/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.search.lucene.monitor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.search.log.Logger;
import com.kingdee.bos.search.log.LoggerFactory;
import com.kingdee.bos.search.lucene.IndexUtil;
import com.kingdee.bos.search.lucene.LuceneEngine;
import com.kingdee.bos.search.lucene.LuceneSendMsg;
import com.kingdee.bos.search.lucene.bean.IndexBizState;
import com.kingdee.bos.search.lucene.bean.LuceneMsg;
import com.kingdee.bos.search.msic.Tool;
import com.kingdee.bos.service.job.util.SQL;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;

public class DeleteProcessTask
implements Runnable {
    protected static final Logger logger = LoggerFactory.REF.get().getLogger(DeleteProcessTask.class);
    private int total;
    private String dc;
    private String[] bosTypes;

    public DeleteProcessTask(String dc, String[] bosTypes, int total) {
        this.dc = dc;
        this.bosTypes = bosTypes;
        this.total = total;
    }

    @Override
    public void run() {
        int num = 0;
        LuceneEngine engine = LuceneEngine.getEngine(this.dc);
        Context ctx = engine.getCtx(this.dc);
        engine.getCleanProgress().put("total", this.total);
        long originCapacity = this.getCapacity(this.dc, LuceneEngine.getIndexRootDir() + File.separator + this.dc);
        do {
            for (String bosType : this.bosTypes) {
                String bizUnit = "biz";
                if (bosType.equals("WORKFLOW")) {
                    bizUnit = "wfr";
                }
                String sql = "select count(*) as num from  " + Tool.getBizLuceneTable(bizUnit) + " where fop = '" + (Object)((Object)IndexBizState.OP_TO_DELETE_LATER) + "'";
                num += DeleteProcessTask.count(this.dc, sql);
                sql = "select count(*) as num from  " + Tool.getBizDelLuceneTable(bizUnit) + " where fop = '" + (Object)((Object)IndexBizState.OP_TO_DELETE_LATER) + "'";
                num += DeleteProcessTask.count(this.dc, sql);
            }
            engine.getCleanProgress().put("processed", this.total - num);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage(), e);
            }
        } while (num > 0);
        engine.forceMergeWriters();
        this.sendMsg(originCapacity, ctx);
    }

    private long getCapacity(String dc, String root) {
        File ir = new File(root);
        File[] fs = ir.listFiles();
        long size = 0L;
        for (File f : fs) {
            size += IndexUtil.sizeOfDirectory(f);
        }
        return size;
    }

    private static int count(String dc, String sql) {
        ArrayList ret = null;
        try {
            ret = SQL.executeQuery((String)dc, (String)sql);
        }
        catch (BOSException e) {
            logger.error("DeleteProcessTask error", e);
        }
        Map item = (Map)ret.get(0);
        int total = Integer.parseInt(item.get("num").toString());
        return total;
    }

    private void sendMsg(long originCapacity, Context ctx) {
        long curCapactity = this.getCapacity(this.dc, LuceneEngine.getIndexRootDir() + File.separator + this.dc);
        String releaseCapacity = IndexUtil.transferUnit(originCapacity - curCapactity);
        String diskUseCapacity = IndexUtil.transferUnit(this.getCapacity(this.dc, LuceneEngine.getIndexRootDir()));
        String diskAvailableCapacity = IndexUtil.transferUnit(new File(LuceneEngine.getIndexRootDir()).getFreeSpace());
        LuceneMsg lucenMsg = new LuceneMsg();
        lucenMsg.setTitle("\u641c\u7d22\u670d\u52a1\u78c1\u76d8\u6e05\u7406\u5b8c\u6210");
        lucenMsg.setBody("\u641c\u7d22\u670d\u52a1\u78c1\u76d8\u6e05\u7406\u5b8c\u6210\uff0c\u5171\u6e05\u7406" + this.total + "\u6761\uff0c\u91ca\u653e" + releaseCapacity + ",\u76ee\u524d\u7d22\u5f15\u5df2\u4f7f\u7528\u78c1\u76d8:" + diskUseCapacity + ",\u78c1\u76d8\u5269\u4f59\u5bb9\u91cf:" + diskAvailableCapacity);
        new LuceneSendMsg(lucenMsg, ctx).send();
    }
}

