/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.search.lucene.monitor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.search.dao.BaseCfgDAO;
import com.kingdee.bos.search.log.Logger;
import com.kingdee.bos.search.log.LoggerFactory;
import com.kingdee.bos.search.lucene.bean.BaseConfig;
import com.kingdee.bos.search.lucene.monitor.LuceneNode;
import com.kingdee.bos.service.job.core.JobIsolationLevel;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.util.MD5Util;
import java.io.File;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public class LuceneNodeTool {
    protected static final Logger logger = LoggerFactory.REF.get().getLogger(LuceneNodeTool.class);

    public static long getFreeDiskSpace() {
        File[] disks;
        long freeSpace = 0L;
        for (File file : disks = File.listRoots()) {
            freeSpace += file.getFreeSpace();
        }
        return freeSpace;
    }

    public static LuceneNode mapToLuceneNode(Map map) {
        String ip = (String)map.get("fip");
        String id = (String)map.get("fid");
        String holder = (String)map.get("fholder");
        Object obj = map.get("ftime");
        Timestamp updateTime = null;
        updateTime = obj == null ? new Timestamp(System.currentTimeMillis()) : (Timestamp)map.get("ftime");
        return new LuceneNode(ip, id, holder, updateTime);
    }

    public static void updateLeaderNode(Context ctx, LuceneNode node) {
        String all = "update T_LUCENE_NODE set fisLeader = 0";
        String selectSql = "select fect from T_LUCENE_NODE where fid=?";
        String sql = "update T_LUCENE_NODE set fisLeader = 1,fect=? where fid =?";
        try {
            SQL.executeUpdate((Context)ctx, (String)all);
            ArrayList list = SQL.executeQuery((Context)ctx, (String)selectSql, (int[])new int[]{12}, (Object[])new Object[]{node.getID()});
            Integer ect = 0;
            for (Object object : list) {
                BigDecimal b = (BigDecimal)((Map)object).get("fect");
                Integer n = ect = Integer.valueOf(b.intValue());
                Integer n2 = ect = Integer.valueOf(ect + 1);
            }
            SQL.executeUpdate((Context)ctx, (String)sql, (int[])new int[]{4, 12}, (Object[])new Object[]{ect, node.getID()});
        }
        catch (BOSException e) {
            logger.error("LuceneNodeTool BOSException in {" + ctx.getAIS() + "}", e);
        }
    }

    public static void initLuceneJob(Set<String> dcInfos, String defid, String triggerid, String jobTitle, String className, JobIsolationLevel jobIsolationLevel, String schedule, boolean isSmallJob) {
        String jobType = isSmallJob ? "Y" : "N";
        String sql = "select 1 from t_job_def where fjobdefid='" + defid + "'";
        Set<String> dcs = dcInfos;
        for (String dc : dcs) {
            try {
                if (SQL.executeQuery((String)dc, (String)sql).size() != 0) continue;
                sql = "INSERT INTO T_JOB_DEF(fjobdefid, ftitle, fispersistent, fhandlerwrapper, fpriority, fissmalljob, fmissedtimeout, fjobisolationlevel, fcreateUserID, fcreateTime, fupdateUserID,fupdateTime) values('" + defid + "','" + jobTitle + "','Y','interface:" + className + "',500, '" + jobType + "', -1, '" + jobIsolationLevel + "','" + "00000000-0000-0000-0000-00000000000013B7DE7F" + "',getdate(),'" + "00000000-0000-0000-0000-00000000000013B7DE7F" + "',getdate())";
                SQL.executeUpdate((String)dc, (String)sql);
                sql = "insert into t_job_trigger(fid,fjobdefid,fvalidatetime,fexpiredtime,fpulsesource, fscheduleplan,fusecalendar,fhashcode,fisolationboundary,fisvalid, fisautoload,ftriggeredcount) values('" + triggerid + "','" + defid + "',?,?,'timer','USERDEFINE:" + schedule + "','N',1,?,'Y','Y',0)";
                int[] types = new int[]{93, 93, 12};
                Timestamp now = new Timestamp(System.currentTimeMillis());
                Timestamp expired = new Timestamp(System.currentTimeMillis() + 3153600000000L);
                Object[] values = new Object[]{now, expired, jobIsolationLevel.getJobIsolationBoundary()};
                SQL.executeUpdate((String)dc, (String)sql, (int[])types, (Object[])values);
                logger.info("LuceneSourceMonitor job def and trigger for {" + dc + "} is created!");
            }
            catch (Exception e) {
                logger.error("LuceneSourceMonitor job def and trigger for {" + dc + "} created Failed", e);
            }
        }
    }

    public static BaseConfig loadBaseCfg(String dc) {
        BaseConfig baseConfig = null;
        try {
            baseConfig = BaseCfgDAO.INS.load(dc);
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), e);
        }
        return baseConfig;
    }

    public static void updateBaseCfg(BaseConfig baseConfig, String dc) throws BOSException {
        try {
            BaseCfgDAO.INS.update(baseConfig, dc);
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), e);
            throw new BOSException((Throwable)e);
        }
    }

    public static void insertBaseCfg(BaseConfig baseConfig, String dc) throws BOSException {
        try {
            BaseCfgDAO.INS.insert(baseConfig, dc);
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), e);
            throw new BOSException((Throwable)e);
        }
    }

    public static String strToUUID(String str) {
        String md5 = MD5Util.getMD5String((String)str);
        String s1 = md5.substring(0, 8);
        String s2 = md5.substring(8, 12);
        String s3 = md5.substring(12, 16);
        String s4 = md5.substring(16, 20);
        String s5 = md5.substring(20, md5.length());
        return s1 + "-" + s2 + "-" + s3 + "-" + s4 + "-" + s5;
    }
}

