/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.search.lucene.monitor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.search.log.Logger;
import com.kingdee.bos.search.log.LoggerFactory;
import com.kingdee.bos.search.lucene.LuceneEngine;
import com.kingdee.bos.search.lucene.bean.SearchApp;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.util.Uuid;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

public class NodeSynchronizer {
    protected static final Logger logger = LoggerFactory.REF.get().getLogger(NodeSynchronizer.class);

    public static void work(String dc) {
        try {
            String uuid = null;
            if (LuceneEngine.getEngine(dc).searchApp() == SearchApp.EASLocal) {
                File nodeInfo = NodeSynchronizer.buildDataFile();
                uuid = NodeSynchronizer.writeUUIDtoFile(nodeInfo);
            } else {
                uuid = LuceneEngine.getIP();
            }
            NodeSynchronizer.updateNodeInfoToDB(dc, uuid);
        }
        catch (Exception e) {
            logger.error("lucene node sync error", e);
        }
    }

    private static void updateNodeInfoToDB(String dc, String uuid) {
        String sql = "select fip from T_LUCENE_NODE where fid = ?";
        try {
            ArrayList ret = SQL.executeQuery((String)dc, (String)sql, (int[])new int[]{12}, (Object[])new Object[]{uuid});
            if (ret.size() > 0) {
                String ip = (String)((Map)ret.get(0)).get("fip");
                if (!ip.equals(LuceneEngine.getIP())) {
                    sql = "update T_LUCENE_NODE set fip =? where fid = ?";
                    SQL.executeUpdate((String)dc, (String)sql, (int[])new int[]{12, 12}, (Object[])new Object[]{LuceneEngine.getIP(), uuid});
                }
            } else {
                LuceneEngine.registerNode(dc, LuceneEngine.getIP(), uuid);
            }
            LuceneEngine.reloadNodeInner(dc, uuid);
        }
        catch (BOSException e) {
            logger.error("BOSException", e);
        }
    }

    private static String writeUUIDtoFile(File nodeInfo) throws IOException {
        FileReader r = new FileReader(nodeInfo);
        char[] c = new char[40];
        int n = r.read(c);
        r.close();
        if (n > 0) {
            return new String(c, 0, n);
        }
        String uuid = Uuid.create().toString();
        FileWriter w = new FileWriter(nodeInfo);
        w.write(uuid);
        w.close();
        return uuid;
    }

    private static File buildDataFile() throws IOException {
        String uuidPath = LuceneEngine.getIndexRootDir() + File.separator + "uuid.data";
        File nodeInfo = new File(uuidPath);
        if (!nodeInfo.exists()) {
            nodeInfo.createNewFile();
        }
        return nodeInfo;
    }
}

