/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.search.lucene.tool;

import com.kingdee.bos.search.dao.SearchBizCfgDAO;
import com.kingdee.bos.search.log.Logger;
import com.kingdee.bos.search.log.LoggerFactory;
import com.kingdee.bos.search.lucene.bean.KSField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KSFieldCache {
    protected static final Logger logger = LoggerFactory.REF.get().getLogger(KSFieldCache.class);
    public static KSFieldCache INS = new KSFieldCache();
    private Map<String, List<KSField>> fieldsMap = new HashMap<String, List<KSField>>();

    public List<KSField> load(String dc, String bosType) {
        List<KSField> fields = this.fieldsMap.get(dc + "/" + bosType);
        if (fields == null) {
            try {
                fields = bosType.equals("easlog") ? this.getLogFields() : SearchBizCfgDAO.INS.load(dc, bosType);
                this.fieldsMap.put(dc + "/" + bosType, fields);
            }
            catch (Exception e) {
                logger.error("load KSField error from " + dc + "/" + bosType, e);
            }
        }
        return fields;
    }

    private List<KSField> getLogFields() {
        ArrayList<KSField> fields = new ArrayList<KSField>();
        fields.add(new KSField("ip_str"));
        fields.add(new KSField("server_str"));
        fields.add(new KSField("trace_id"));
        fields.add(new KSField("logFile"));
        fields.add(new KSField("timestamp"));
        fields.add(new KSField("message"));
        fields.add(new KSField("codeLocation"));
        return fields;
    }
}

