/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.search.msic;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.search.lucene.LuceneEngine;
import com.kingdee.bos.search.lucene.bean.IndexBizState;
import com.kingdee.bos.search.lucene.bean.SearchApp;
import com.kingdee.bos.search.lucene.bean.TempBizId;
import com.kingdee.bos.search.lucene.monitor.LuceneNode;
import com.kingdee.bos.search.msic.Tool;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class DMLTool {
    public static void addBizDataToDB(Context ctx, TempBizId bizData) throws Exception {
        String sql = "insert into " + Tool.getBizLuceneTable(bizData.getBizUnit()) + " (fbillId,fbostype,fnode,fdc,fop,foptime) values(?,?,?,?,?,?)";
        Set<LuceneNode> nodes = LuceneEngine.getNodeSet(ctx);
        Iterator<LuceneNode> ite = DMLTool.filterNodeSet(ctx, nodes).iterator();
        while (ite.hasNext()) {
            SQL.executeUpdate((Context)ctx, (String)sql, (int[])new int[]{12, 12, 12, 12, 12, 93}, (Object[])new Object[]{bizData.getBizId(), bizData.getBosType(), ite.next().getID(), ctx.getAIS(), IndexBizState.OP_TO_ADD.name(), Tool.now()});
        }
    }

    public static boolean checkIfBizDataInDB(Context ctx, TempBizId bizData) throws BOSException {
        String sql = "select fbillId from " + Tool.getBizLuceneTable(bizData.getBizUnit()) + "  where fnode =? and fdc =? and fbillId =?";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{LuceneEngine.getNode().getID(), ctx.getAIS(), bizData.getBizId()});
        return rowSet.size() > 0;
    }

    public static int deleteBizDataFromDB(String dc, String bizUnit, String billId) throws BOSException {
        String sql = "delete from " + Tool.getBizLuceneTable(bizUnit) + " where fbillid=?";
        return SQL.executeUpdate((String)dc, (String)sql, (int[])new int[]{12}, (Object[])new Object[]{billId});
    }

    public static int deleteBizFinishedData(String dc, String bizUnit, String billId) throws BOSException {
        String sql = "delete from " + Tool.getBizDelLuceneTable(bizUnit) + " where fbillid=?";
        return SQL.executeUpdate((String)dc, (String)sql, (int[])new int[]{12}, (Object[])new Object[]{billId});
    }

    public static void updateBizDataStateToDB(Context ctx, TempBizId bizData) throws Exception {
        String state = bizData.getOp().toString();
        String sql = "update " + Tool.getBizLuceneTable(bizData.getBizUnit()) + " set fop = ?,foptime = ? where fbillId = ?  and fnode= ? and fdc = ? and fop = '" + (Object)((Object)IndexBizState.OP_DO_NOTHING) + "'";
        Set<LuceneNode> nodes = LuceneEngine.getNodeSet(ctx);
        Iterator<LuceneNode> ite = DMLTool.filterNodeSet(ctx, nodes).iterator();
        while (ite.hasNext()) {
            String id = ite.next().getID();
            if (!LuceneEngine.getNode().getID().equals(id)) {
                String query = "select fbillId from " + Tool.getBizLuceneTable(bizData.getBizUnit()) + " where fnode = ?  and fbillId = ?";
                ArrayList list = SQL.executeQuery((Context)ctx, (String)query, (int[])new int[]{12, 12}, (Object[])new Object[]{id, bizData.getBizId()});
                if (list.size() == 0) {
                    sql = "insert into " + Tool.getBizLuceneTable(bizData.getBizUnit()) + "(fop,foptime,fbillId,fnode,fdc) values(?,?,?,?,?)";
                }
            }
            SQL.executeUpdate((Context)ctx, (String)sql, (int[])new int[]{12, 93, 12, 12, 12}, (Object[])new Object[]{state, Tool.now(), bizData.getBizId(), id, ctx.getAIS()});
        }
    }

    private static Set<LuceneNode> filterNodeSet(Context ctx, Set<LuceneNode> nodes) {
        LuceneEngine engine = LuceneEngine.getEngine(ctx.getAIS());
        if (engine.searchApp() == SearchApp.EASLocal) {
            return nodes;
        }
        String nodeId = LuceneEngine.getNode().getID();
        HashSet<LuceneNode> set = new HashSet<LuceneNode>();
        for (LuceneNode node : nodes) {
            String id = node.getID();
            if (!id.equals(nodeId)) continue;
            set.add(node);
        }
        return set;
    }
}

