/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.search.schema;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.search.biz.DocBuilderManager;
import com.kingdee.bos.search.biz.IDocumentBuilder;
import com.kingdee.bos.search.db.DbClient;
import com.kingdee.bos.search.ksconnection.KSearchConnection;
import com.kingdee.bos.search.log.Logger;
import com.kingdee.bos.search.log.LoggerFactory;
import com.kingdee.bos.search.lucene.LuceneEngine;
import com.kingdee.bos.search.lucene.LuceneSendMsg;
import com.kingdee.bos.search.lucene.bean.LuceneBizId;
import com.kingdee.bos.search.lucene.bean.LuceneMsg;
import com.kingdee.bos.search.lucene.bean.SearchBizCfg;
import com.kingdee.bos.search.msic.SerializationUtil;
import com.kingdee.bos.search.schema.DateRange;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.util.db.SQLUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;

public class DocDataImport
implements Runnable {
    protected static final Logger logger = LoggerFactory.REF.get().getLogger(DocDataImport.class);
    private int offset = 30;
    private long dayMs = 86400000L;
    private SearchBizCfg bizcfg;
    private String createTimeField;
    private DateRange dateRange;
    private List<DateRange> dateRanges;
    private Context ctx;
    private float progress = 0.0f;
    private boolean redo = false;
    private int total = 0;

    public DocDataImport(Context ctx, SearchBizCfg bizcfg, String createTimeField, DateRange dateRange) {
        this.ctx = ctx;
        this.bizcfg = bizcfg;
        this.createTimeField = createTimeField;
        this.dateRange = dateRange;
    }

    public DocDataImport(Context ctx, SearchBizCfg bizcfg, String createTimeField, List<DateRange> dateRanges, boolean redo) {
        this.ctx = ctx;
        this.bizcfg = bizcfg;
        this.createTimeField = createTimeField;
        this.dateRanges = dateRanges;
        this.redo = redo;
    }

    @Override
    public void run() {
        this.innerRun();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerRun() {
        String bosType = this.bizcfg.getBosType();
        IDocumentBuilder builder = DocBuilderManager.get(this.ctx.getAIS(), bosType);
        KSearchConnection ksConn = null;
        try {
            List<DateRange> dateRanges = null;
            dateRanges = this.redo ? this.dateRanges : this.ranges(this.dateRange);
            this.deleteErrorSyncData(dateRanges);
            ksConn = this.getKSconn();
            ArrayList<DateRange> faileds = new ArrayList<DateRange>();
            int p = 0;
            int success = 0;
            float sizef = dateRanges.size();
            boolean accurError = false;
            for (DateRange range : dateRanges) {
                int n = 0;
                try {
                    n = "WORKFLOW".equals(bosType) ? this.updateDocWF(builder, ksConn, range) : this.updateDoc(builder, ksConn, range);
                }
                catch (Exception e) {
                    accurError = true;
                    faileds.add(range);
                    this.saveFailedToDB(range, SerializationUtil.dump(e));
                }
                success += n;
                this.progress = (float)(++p) / sizef;
            }
            this.updateBizCfg(accurError);
            this.sendMsg(success, faileds, accurError);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
        finally {
            try {
                LuceneEngine.getEngine(this.ctx.getAIS()).returnKSConnection(this.ctx.getAIS(), this.bizcfg.getBosType(), ksConn);
            }
            catch (Exception e) {
                logger.error("reuturnKSConnection fail", e);
            }
        }
    }

    private int updateDoc(IDocumentBuilder builder, KSearchConnection ksConn, DateRange range) throws Exception {
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>();
        List<String> idList = this.getBizObjId(range);
        this.total += idList.size();
        int n = 0;
        for (String id : idList) {
            LuceneBizId biz = new LuceneBizId();
            biz.setBizId(id);
            Map<String, Object> docMap = null;
            try {
                docMap = builder.buildMap(biz);
            }
            catch (Exception e) {
                logger.error("build doc error{" + id + "}", e);
            }
            if (docMap == null) continue;
            maps.add(docMap);
            ++n;
        }
        ksConn.updateDocs(this.ctx.getAIS(), this.bizcfg.getBosType(), maps);
        return n;
    }

    private int updateDocWF(IDocumentBuilder builder, KSearchConnection ksConn, DateRange range) throws Exception {
        List<String> idList = this.getBizObjIdWF(range);
        this.total += idList.size();
        ArrayList<Document> docs = new ArrayList<Document>();
        int n = 0;
        for (String id : idList) {
            LuceneBizId biz = new LuceneBizId();
            biz.setBizId(id);
            List<Document> doc = null;
            try {
                doc = builder.buildDocs(biz);
            }
            catch (Exception e) {
                logger.error("build doc error{" + id + "}", e);
            }
            if (doc == null) continue;
            docs.addAll(doc);
            ++n;
        }
        ksConn.updateDoc(this.ctx.getAIS(), this.bizcfg.getBosType(), docs);
        return n;
    }

    private KSearchConnection getKSconn() {
        KSearchConnection ksConn = null;
        try {
            ksConn = LuceneEngine.getEngine(this.ctx.getAIS()).getKSConnection(this.ctx.getAIS(), this.bizcfg.getBosType());
        }
        catch (Exception e1) {
            throw new RuntimeException("get KSearchConnection error." + e1);
        }
        return ksConn;
    }

    public float getProgress() {
        return this.progress;
    }

    private void saveFailedToDB(DateRange range, String errorInfo) {
        String uuid = SerializationUtil.toUUID(this.bizcfg.getBosType() + range.toString()).toString();
        String insert = "insert into t_lucene_dataSyncRedo(fid,fbostype,fsynctime,ferrorInfo,fcreatetime) values(?,?,?,?,?)";
        try {
            Timestamp stamp = new Timestamp(System.currentTimeMillis());
            DbClient.update(this.ctx.getAIS(), insert, new int[]{12, 12, 12, 12, 93}, new Object[]{uuid, this.bizcfg.getBosType(), range.toString(), errorInfo, stamp});
        }
        catch (SQLException e) {
            logger.error("inert redo error", e);
        }
    }

    private List<DateRange> ranges(DateRange dateRange) {
        ArrayList<DateRange> dateRanges = new ArrayList<DateRange>();
        Timestamp start = dateRange.getStart();
        Timestamp end = dateRange.getEnd();
        long offsetMs = (long)this.offset * this.dayMs;
        long rangeMs = end.getTime() - start.getTime();
        int n = (int)(rangeMs / offsetMs);
        if (n == 0) {
            dateRanges.add(dateRange);
            return dateRanges;
        }
        for (int i = 0; i < n; ++i) {
            Timestamp startN = new Timestamp(start.getTime() + offsetMs * (long)i);
            Timestamp endN = new Timestamp(start.getTime() + offsetMs * (long)(i + 1));
            if (endN.after(end)) {
                endN = end;
            }
            DateRange temp = new DateRange(startN, endN);
            dateRanges.add(temp);
        }
        return dateRanges;
    }

    private void sendMsg(int success, List<DateRange> faileds, boolean accurError) {
        LuceneMsg lucenMsg = new LuceneMsg();
        String msg = "\u6587\u6863\u6570\u636e\u5bfc\u5165\u5b8c\u6210.\u5171\u67e5\u8be2\u51fa" + this.total + "\u6761\u6570\u636e\uff0c\u6210\u529f\u5bfc\u5165" + success + "\u6761";
        if (accurError) {
            String times = "";
            for (DateRange dateRange : faileds) {
                times = times + dateRange.getStart() + " ~ " + dateRange.getEnd();
                times = times + "\r\n";
            }
            msg = msg + "\u4ee5\u4e0b\u65f6\u95f4\u6bb5\u7684\u4e1a\u52a1\u6570\u636e\u5bfc\u5165\u5931\u8d25\uff1a\r\n" + times;
        }
        lucenMsg.setTitle("\u6587\u6863\u6570\u636e\u5bfc\u5165\u5b8c\u6210");
        lucenMsg.setBody(msg);
        new LuceneSendMsg(lucenMsg, this.ctx).send();
    }

    private void updateBizCfg(boolean accurError) {
        int state = 0;
        try {
            if (this.redo) {
                String selSql = "select count(1) as count from t_lucene_dataSyncRedo where fbostype = ?";
                ArrayList results = DbClient.query(this.ctx.getAIS(), selSql, new int[]{12}, new Object[]{this.bizcfg.getBosType()});
                BigDecimal temp = (BigDecimal)((Map)results.get(0)).get("count");
                int count = temp.intValue();
                if (count > 0) {
                    state = 1;
                }
            } else if (accurError) {
                state = 1;
            }
            String sql = "update T_LUCENE_BIZCFG set fstate = ?,fstarttime = ? where fbostype = ?";
            DbClient.update(this.ctx.getAIS(), sql, new int[]{4, 93, 12}, new Object[]{state, this.dateRange.getStart(), this.bizcfg.getBosType()});
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u72b6\u6001\u5931\u8d25\uff01bostype:" + this.bizcfg.getBosType(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getBizObjId(DateRange range) {
        EntityViewInfo entity = new EntityViewInfo();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        entity.setSelector(selectors);
        FilterInfo filter = new FilterInfo();
        FilterItemInfo fiiStart = new FilterItemInfo(this.createTimeField, (Object)range.getStart(), CompareType.GREATER_EQUALS);
        FilterItemInfo fiiEnd = new FilterItemInfo(this.createTimeField, (Object)range.getEnd(), CompareType.LESS_EQUALS);
        filter.getFilterItems().add(fiiStart);
        filter.getFilterItems().add(fiiEnd);
        filter.setMaskString("#0 and #1");
        entity.setFilter(filter);
        IORMappingDAO dao = null;
        IObjectCollection objectCol = null;
        Connection cn = null;
        ArrayList<String> idLIst = new ArrayList<String>();
        try {
            cn = EJBFactory.getConnection((Context)this.ctx);
            dao = ORMappingDAO.getInstance((BOSObjectType)BOSObjectType.create((String)this.bizcfg.getBosType()), (Context)this.ctx, (Connection)cn);
            objectCol = dao.getCollection(entity);
            for (int i = 0; i < objectCol.size(); ++i) {
                IObjectValue o = objectCol.getObject(i);
                idLIst.add(o.getString("id"));
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), e);
        }
        catch (DataAccessException e) {
            logger.error(e.getMessage(), e);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        return idLIst;
    }

    private List<String> getBizObjIdWF(DateRange range) {
        ArrayList<String> idList = new ArrayList<String>();
        String sql = "SELECT b.FREFID as fid FROM T_wfr_procinst a inner join T_WFR_PROCINSTREF b on a.FPROCINSTID=b.FPROCINSTID where a.FCREATEDTIME>{ts'" + range.getStart().toString().substring(0, 19) + "'} and  a.FCREATEDTIME<{ts'" + range.getEnd().toString().substring(0, 19) + "'} and b.FTYPE=1 ";
        ArrayList results = null;
        try {
            results = DbClient.query(this.ctx.getAIS(), sql);
            if (results == null || results.size() == 0) {
                // empty if block
            }
            for (Object obj : results) {
                String id = (String)((Map)obj).get("fid");
                BOSUuid boid = BOSUuid.read((String)id);
                String bosType = boid.getType().toString();
                if ("63D30103".equals(bosType) || "C7CEA331".equals(bosType)) continue;
                idList.add(id);
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), e);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), e);
        }
        return idList;
    }

    private void deleteErrorSyncData(List<DateRange> dateRanges) throws Exception {
        if (dateRanges.size() == 0) {
            return;
        }
        StringBuffer filter = new StringBuffer();
        for (DateRange dateRange : dateRanges) {
            String uuid = SerializationUtil.toUUID(this.bizcfg.getBosType() + dateRange.toString()).toString();
            filter.append("'").append(uuid).append("',");
        }
        String sql = "delete from t_lucene_dataSyncRedo where fid in (" + filter.substring(0, filter.length() - 1) + ")";
        DbClient.update(this.ctx.getAIS(), sql);
    }
}

