/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.search.schema;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.search.log.Logger;
import com.kingdee.bos.search.log.LoggerFactory;
import com.kingdee.bos.search.lucene.bean.KSField;
import com.kingdee.bos.search.lucene.bean.SearchBizCfg;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class KSearchSchema {
    protected static final Logger logger = LoggerFactory.REF.get().getLogger(KSearchSchema.class);

    public static boolean ping(String baseUrl) {
        try {
            KSearchSchema.GET(baseUrl, 30);
        }
        catch (IOException e) {
            logger.error("ping " + baseUrl + " error", e);
            return false;
        }
        return true;
    }

    public static boolean buildBizIndexDir(String baseUrl, String dc, SearchBizCfg bizCfg) throws SQLException {
        if (!bizCfg.isEnable()) {
            return false;
        }
        try {
            KSearchSchema.createBizDir(baseUrl, dc, bizCfg);
            return KSearchSchema.buildBizSchema(baseUrl, dc, bizCfg);
        }
        catch (IOException e) {
            logger.error("buildBizIndexDir " + baseUrl + "," + bizCfg.getBosType() + " error", e);
            return false;
        }
    }

    private static List<String> getHitList() {
        ArrayList<String> hitList = new ArrayList<String>();
        hitList.add("_nest_path_");
        hitList.add("_root_");
        hitList.add("_text_");
        hitList.add("_version_");
        hitList.add("id");
        return hitList;
    }

    private static byte[] getUpdateSchemaData(List solrFields, SearchBizCfg bizCfg) {
        List<KSField> ksFields = bizCfg.getFields();
        ArrayList<HashMap<String, String>> mapList = new ArrayList<HashMap<String, String>>();
        ArrayList<HashMap<String, String>> mapListCopy = new ArrayList<HashMap<String, String>>();
        List<String> hitList = KSearchSchema.getHitList();
        String fname = null;
        for (KSField field : ksFields) {
            boolean hit = false;
            String ksName = field.getName();
            for (Object obj : solrFields) {
                Map map = (Map)obj;
                fname = (String)map.get("name");
                if (!ksName.equals(fname)) continue;
                hit = true;
                break;
            }
            if (hit) {
                hitList.add(ksName);
                continue;
            }
            mapList.add(field.getSchemaAddMap());
            mapListCopy.add(field.getSchemaAddCopyFieldMap());
        }
        ArrayList<HashMap<String, String>> mapList2 = new ArrayList<HashMap<String, String>>();
        ArrayList<HashMap<String, String>> mapListCopy2 = new ArrayList<HashMap<String, String>>();
        for (Object obj : solrFields) {
            Map map = (Map)obj;
            fname = (String)map.get("name");
            boolean hit = false;
            for (String ksName : hitList) {
                if (!ksName.equals(fname)) continue;
                hit = true;
                break;
            }
            if (hit) continue;
            mapList2.add(KSearchSchema.getSchemaDelMap(fname));
            mapListCopy2.add(KSearchSchema.getSchemaDelCopyMap(fname));
        }
        LinkedHashMap<String, ArrayList<HashMap<String, String>>> toUpdate = new LinkedHashMap<String, ArrayList<HashMap<String, String>>>();
        if (mapList.size() > 0) {
            toUpdate.put("add-field", mapList);
            toUpdate.put("add-copy-field", mapListCopy);
        }
        if (mapList2.size() > 0) {
            toUpdate.put("delete-copy-field", mapListCopy2);
            toUpdate.put("delete-field", mapList2);
        }
        if (toUpdate.size() == 0) {
            return null;
        }
        String json = JSON.toJSONString(toUpdate);
        return json.getBytes();
    }

    private static List getSchemaFields(String baseUrl, String dc, String bosType) {
        String urlStr = baseUrl + dc + "_" + bosType + "/schema/fields";
        try {
            Map map = KSearchSchema.GETRESP(urlStr);
            return (List)map.get("fields");
        }
        catch (IOException e) {
            logger.error("get schema fields error", e);
            return null;
        }
    }

    public static boolean unloadCore(String baseUrl, String dc, String bostype) {
        String url = baseUrl + "admin/cores?action=UNLOAD&core=" + dc + "_" + bostype;
        try {
            KSearchSchema.GET(url);
        }
        catch (IOException e) {
            logger.error("UNLOAD failed,path:" + url, e);
            return false;
        }
        url = baseUrl + "ksearch?cmd=DELDIR&bizKey=eas/" + dc + "/" + bostype;
        try {
            KSearchSchema.GET(url);
        }
        catch (IOException e) {
            logger.error("DELDIR failed,path:" + url, e);
            return false;
        }
        return true;
    }

    private static void createBizDir(String baseUrl, String dc, SearchBizCfg bizCfg) throws MalformedURLException, IOException {
        if ("easlog".equals(bizCfg.getBosType())) {
            dc = "EASLOG";
        }
        String createBizDirUrl = baseUrl + "ksearch?cmd=CREATEDIR&dc=eas/" + dc + "&bosType=";
        createBizDirUrl = createBizDirUrl + bizCfg.getBosType();
        KSearchSchema.GET(createBizDirUrl);
    }

    private static void GET(String urlStr) throws IOException {
        KSearchSchema.GET(urlStr, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void GET(String urlStr, int timeout) throws IOException {
        HttpURLConnection connection = null;
        InputStream is = null;
        try {
            URL url = new URL(urlStr);
            connection = (HttpURLConnection)url.openConnection();
            if (timeout > 0) {
                connection.setConnectTimeout(timeout * 1000);
            }
            connection.connect();
            is = connection.getInputStream();
        }
        catch (Throwable throwable) {
            KSearchSchema.close(null, is, connection);
            throw throwable;
        }
        KSearchSchema.close(null, is, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map GETRESP(String urlStr) throws IOException {
        Map map;
        HttpURLConnection connection = null;
        InputStream is = null;
        try {
            Map map2;
            URL url = new URL(urlStr);
            connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(30000);
            connection.connect();
            is = connection.getInputStream();
            StringBuilder result = new StringBuilder();
            BufferedReader in = new BufferedReader(new InputStreamReader(is));
            if (in != null) {
                String line = "";
                while ((line = in.readLine()) != null) {
                    result.append(line);
                }
            }
            map = map2 = (Map)JSON.parseObject((String)result.toString(), Map.class);
        }
        catch (Throwable throwable) {
            KSearchSchema.close(null, is, connection);
            throw throwable;
        }
        KSearchSchema.close(null, is, connection);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String POST(String urlStr, byte[] data) throws IOException {
        HttpURLConnection conn = null;
        OutputStream out = null;
        InputStream iss = null;
        try {
            URL url = new URL(urlStr);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(5000);
            conn.setDoOutput(true);
            conn.setRequestProperty("Content-Type", "application/json;charset=utf-8");
            out = conn.getOutputStream();
            out.write(data);
            out.flush();
            conn.connect();
            iss = conn.getInputStream();
        }
        catch (Throwable throwable) {
            KSearchSchema.close(out, iss, conn);
            throw throwable;
        }
        KSearchSchema.close(out, iss, conn);
        return null;
    }

    public static boolean buildBizSchema(String baseUrl, String dc, SearchBizCfg bizCfg) throws IOException {
        if (bizCfg.getFields() == null) {
            return false;
        }
        List solrFields = KSearchSchema.getSchemaFields(baseUrl, dc, bizCfg.getBosType());
        String schemaUrl = baseUrl + dc + "_" + bizCfg.getBosType() + "/schema";
        byte[] data = KSearchSchema.getUpdateSchemaData(solrFields, bizCfg);
        if (data == null) {
            return true;
        }
        KSearchSchema.POST(schemaUrl, data);
        return true;
    }

    public static Map getKsMonitorInfo(String baseUrl) throws IOException {
        String url = baseUrl + "ksMonitor";
        Map map = KSearchSchema.GETRESP(url);
        return map;
    }

    private static void close(OutputStream out, InputStream in, HttpURLConnection conn) {
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (Exception e) {
            logger.error("close OutputStream error", e);
        }
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (Exception e) {
            logger.error("close InputStream error", e);
        }
        if (conn != null) {
            conn.disconnect();
        }
    }

    private static HashMap<String, String> getSchemaDelMap(String name) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", name);
        return map;
    }

    private static HashMap<String, String> getSchemaDelCopyMap(String name) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("source", name);
        map.put("dest", "_text_");
        return map;
    }
}

