/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.sql.formater;

import com.kingdee.bos.sql.dom.SqlColumnDef;
import com.kingdee.bos.sql.dom.SqlInsert;
import com.kingdee.bos.sql.dom.SqlJoinedTableSource;
import com.kingdee.bos.sql.dom.SqlOrderByItem;
import com.kingdee.bos.sql.dom.SqlSelect;
import com.kingdee.bos.sql.dom.SqlSelectItem;
import com.kingdee.bos.sql.dom.SqlSubQueryTableSource;
import com.kingdee.bos.sql.dom.SqlTableSource;
import com.kingdee.bos.sql.dom.SqlTableSourceBase;
import com.kingdee.bos.sql.dom.expr.SqlAggregateExpr;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.sql.dom.expr.SqlIdentifierExpr;
import com.kingdee.bos.sql.dom.expr.SqlNCharExpr;
import com.kingdee.bos.sql.dom.stmt.SqlInsertStmt;
import com.kingdee.bos.sql.formater.DMHints;
import com.kingdee.bos.sql.formater.DMSQLFormaterOld;
import com.kingdee.bos.sql.formater.FormaterException;
import com.kingdee.bos.sql.parser.Token;
import java.util.Iterator;
import java.util.List;

public class DMSQLFormater
extends DMSQLFormaterOld {
    public DMSQLFormater() {
        super(null);
    }

    public DMSQLFormater(StringBuffer sb) {
        super(sb);
    }

    @Override
    public DMHints getHints() {
        return DMHints.getInstance();
    }

    @Override
    protected void formatNChar(SqlNCharExpr expr) throws FormaterException {
        this.buffer.append("N'");
        this.buffer.append(expr.text);
        this.buffer.append("'");
    }

    @Override
    protected void formatInsertStmt(SqlInsertStmt stmt) throws FormaterException {
        int i;
        boolean flag;
        boolean hasRowNum = false;
        SqlInsert insert = stmt.insert;
        this.buffer.append("INSERT ");
        if (insert.getHints() != null && !insert.getHints().isEmpty()) {
            this.getHints().formatHints(insert.getHints(), insert, this.buffer);
            this.buffer.append("INTO ");
        } else {
            this.buffer.append("INTO ");
        }
        this.buffer.append(insert.tableName);
        if (!insert.columnList.isEmpty()) {
            this.buffer.append(" (");
            flag = false;
            for (i = 0; i < insert.columnList.size(); ++i) {
                Object colItem;
                if (flag) {
                    this.buffer.append(", ");
                }
                if ((colItem = insert.columnList.get(i)) instanceof SqlIdentifierExpr) {
                    SqlIdentifierExpr identExpr = (SqlIdentifierExpr)colItem;
                    if (identExpr.value.equalsIgnoreCase("KSQL_SEQ")) {
                        hasRowNum = true;
                    }
                    this.buffer.append(identExpr.value);
                } else if (colItem instanceof String) {
                    this.buffer.append((String)colItem);
                } else {
                    throw new FormaterException("unexpect expression: '" + colItem + "'");
                }
                flag = true;
            }
            this.buffer.append(")");
        }
        if (insert.valueList.size() != 0) {
            this.buffer.append(" VALUES (");
            flag = false;
            for (i = 0; i < insert.valueList.size(); ++i) {
                if (flag) {
                    this.buffer.append(", ");
                }
                SqlExpr valueExpr = (SqlExpr)insert.valueList.get(i);
                this.formatExpr(valueExpr);
                flag = true;
            }
            this.buffer.append(")");
        } else {
            this.buffer.append(" ");
            if (hasRowNum) {
                this.buffer.append("SELECT ROWNUM,KSQL_V1.* FROM (");
            }
            this.formatSelectBase(stmt.insert.subQuery);
            if (hasRowNum) {
                this.buffer.append(") KSQL_V1");
            }
        }
    }

    @Override
    protected void formatColumnDef(SqlColumnDef column) throws FormaterException {
        this.buffer.append(column.name);
        this.buffer.append(" ");
        if (column.dataType.equalsIgnoreCase("CHAR")) {
            this.buffer.append("CHAR (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("VARCHAR") || column.dataType.equalsIgnoreCase("VARCHAR2")) {
            this.buffer.append("VARCHAR2 (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("NCHAR")) {
            this.buffer.append("NCHAR (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("NVARCHAR") || column.dataType.equalsIgnoreCase("NVARCHAR2")) {
            this.buffer.append("NVARCHAR2 (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("NUMBER") || column.dataType.equalsIgnoreCase("DECIMAL")) {
            if (column.precision >= 0) {
                this.buffer.append("NUMBER (");
                this.buffer.append(column.precision);
                this.buffer.append(", ");
                this.buffer.append(column.scale);
                this.buffer.append(")");
            } else {
                this.buffer.append("NUMBER");
            }
        } else if (column.dataType.equalsIgnoreCase("INT") && !column.autoIncrement || column.dataType.equalsIgnoreCase("INTEGER") && !column.autoIncrement) {
            this.buffer.append("NUMBER (10)");
        } else if (column.dataType.equalsIgnoreCase("SMALLINT")) {
            this.buffer.append("NUMBER (10)");
        } else if (column.dataType.equalsIgnoreCase("DATETIME") || column.dataType.equalsIgnoreCase("DATE")) {
            this.buffer.append("TIMESTAMP");
        } else if (column.dataType.equalsIgnoreCase("LONG")) {
            this.buffer.append("LONG");
        } else if (column.dataType.equalsIgnoreCase("RAW") || column.dataType.equalsIgnoreCase("BINARY")) {
            this.buffer.append("RAW (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("LONG RAW") || column.dataType.equalsIgnoreCase("VARBINARY")) {
            this.buffer.append("LONG RAW");
        } else if (column.dataType.equalsIgnoreCase("ROWID")) {
            this.buffer.append("ROWID");
        } else if (column.dataType.equalsIgnoreCase("BLOB")) {
            this.buffer.append("BLOB");
        } else if (column.dataType.equalsIgnoreCase("CLOB")) {
            this.buffer.append("CLOB");
        } else if (column.dataType.equalsIgnoreCase("NCLOB")) {
            this.buffer.append("NCLOB");
        } else if (column.dataType.equalsIgnoreCase("BFILE")) {
            this.buffer.append("BFILE");
        } else if (column.dataType.equalsIgnoreCase("UROWID")) {
            this.buffer.append("UROWID");
        } else if (column.dataType.equalsIgnoreCase("FLOAT")) {
            if (column.length != 0) {
                this.buffer.append("FLOAT (");
                this.buffer.append(column.length);
                this.buffer.append(")");
            } else {
                this.buffer.append("FLOAT");
            }
        } else if (column.dataType.equalsIgnoreCase("INT") && column.autoIncrement) {
            this.buffer.append("INT");
            this.context.put("Identity", column.name);
        } else {
            throw new FormaterException("not support datatype, column name is '" + column.name + "' datatype is '" + column.dataType + "'");
        }
        if (column.defaultValueExpr != null) {
            this.buffer.append(" DEFAULT ");
            this.formatExpr(column.defaultValueExpr);
        }
        if (column.allowNull != null && column.allowNull == Boolean.TRUE) {
            if (!column.isPrimaryKey) {
                this.buffer.append(" NULL");
            }
        } else if (column.allowNull != null && column.allowNull == Boolean.FALSE) {
            this.buffer.append(" NOT NULL");
        }
        if (column.containtName != null && column.containtName.length() != 0) {
            this.validConstraintName(column.containtName);
            this.buffer.append(" CONSTRAINT ");
            this.buffer.append(column.containtName);
        }
        if (column.isPrimaryKey) {
            this.buffer.append(" PRIMARY KEY");
        }
        if (column.isUnique) {
            this.buffer.append(" UNIQUE");
        }
        if (column.checkExpr != null) {
            this.buffer.append(" CHECK (");
            this.formatExpr(column.checkExpr);
            this.buffer.append(")");
        }
    }

    @Override
    protected void formatSelect(SqlSelect select) throws FormaterException {
        if (select.into != null) {
            this.buffer.append("CREATE TABLE ");
            this.buffer.append(select.into.new_table);
            this.buffer.append(" AS ");
        }
        if (select.limit != null && (select.orderBy.size() != 0 || select.groupBy.size() != 0)) {
            this.buffer.append("SELECT * FROM (SELECT ");
        } else {
            this.buffer.append("SELECT ");
        }
        this.getHints().formatHints(select.getHints(), select, this.buffer);
        if (select.distinct == 1) {
            this.buffer.append("DISTINCT ");
        } else if (select.distinct != 0) {
            throw new FormaterException("distinct option not support.");
        }
        Iterator iterator = null;
        boolean flag = false;
        for (int i = 0; i < select.selectList.size(); ++i) {
            SqlIdentifierExpr tableNameExpr;
            SqlIdentifierExpr columnNameExpr;
            SqlSelectItem item;
            block100: {
                block98: {
                    block110: {
                        block109: {
                            block108: {
                                block107: {
                                    block106: {
                                        block105: {
                                            block104: {
                                                block103: {
                                                    block102: {
                                                        block101: {
                                                            block99: {
                                                                if (flag) {
                                                                    this.buffer.append(", ");
                                                                }
                                                                item = (SqlSelectItem)select.selectList.get(i);
                                                                this.paramData.changeSelectColumn(select, item);
                                                                if (!(item.expr instanceof SqlIdentifierExpr)) break block98;
                                                                if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NAME.value) || item.alias != null) break block99;
                                                                item.alias = Token.KSQL_COL_NAME.value;
                                                                break block100;
                                                            }
                                                            if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.TABNAME.value) || item.alias != null) break block101;
                                                            item.alias = Token.TABNAME.value;
                                                            break block100;
                                                        }
                                                        if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CREATETIME.value) || item.alias != null) break block102;
                                                        item.alias = Token.KSQL_CREATETIME.value;
                                                        break block100;
                                                    }
                                                    if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_TABNAME.value) || item.alias != null) break block103;
                                                    item.alias = Token.KSQL_COL_TABNAME.value;
                                                    break block100;
                                                }
                                                if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_LENGTH.value) || item.alias != null) break block104;
                                                item.alias = Token.KSQL_COL_LENGTH.value;
                                                break block100;
                                            }
                                            if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_TYPE.value) || item.alias != null) break block105;
                                            item.alias = Token.KSQL_COL_TYPE.value;
                                            break block100;
                                        }
                                        if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NULLABLE.value) || item.alias != null) break block106;
                                        item.alias = Token.KSQL_COL_NULLABLE.value;
                                        break block100;
                                    }
                                    if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_DEFAULT.value) || item.alias != null) break block107;
                                    item.alias = Token.KSQL_COL_DEFAULT.value;
                                    break block100;
                                }
                                if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.INDNAME.value) || item.alias != null) break block108;
                                item.alias = Token.INDNAME.value;
                                break block100;
                            }
                            if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_NAME.value) || item.alias != null) break block109;
                            item.alias = Token.KSQL_CONS_NAME.value;
                            break block100;
                        }
                        if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TABNAME.value) || item.alias != null) break block110;
                        item.alias = Token.KSQL_CONS_TABNAME.value;
                        break block100;
                    }
                    if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TYPE.value) || item.alias != null) break block100;
                    item.alias = Token.KSQL_CONS_TYPE.value;
                    break block100;
                }
                if (item.expr instanceof SqlAggregateExpr) {
                    List TparamList = ((SqlAggregateExpr)item.expr).paramList;
                    for (SqlExpr param : TparamList) {
                        if (!(param instanceof SqlIdentifierExpr)) continue;
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_COL_NAME.value)) {
                            ((SqlIdentifierExpr)param).value = "COLUMN_NAME";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_COL_TABNAME.value)) {
                            ((SqlIdentifierExpr)param).value = "TABLE_NAME";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.TABNAME.value)) {
                            ((SqlIdentifierExpr)param).value = "TABLE_NAME";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.INDNAME.value)) {
                            ((SqlIdentifierExpr)param).value = "INDEX_NAME";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_CONS_NAME.value)) {
                            ((SqlIdentifierExpr)param).value = "CONSTRAINT_NAME";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_CONS_TABNAME.value)) {
                            ((SqlIdentifierExpr)param).value = "TABLE_NAME";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_CONS_TYPE.value)) {
                            ((SqlIdentifierExpr)param).value = "CONSTRAINT_TYPE";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_COL_DEFAULT.value)) {
                            ((SqlIdentifierExpr)param).value = "DATA_DEFAULT";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_COL_NULLABLE.value)) {
                            ((SqlIdentifierExpr)param).value = "NULLABLE";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_COL_LENGTH.value)) {
                            ((SqlIdentifierExpr)param).value = "DATA_LENGTH";
                            continue;
                        }
                        if (!((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_COL_TYPE.value)) continue;
                        ((SqlIdentifierExpr)param).value = "DATA_TYPE";
                    }
                }
            }
            if (item.alias != null && item.alias.length() != 0) {
                if (item.expr instanceof SqlIdentifierExpr) {
                    if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NAME.value)) {
                        columnNameExpr = new SqlIdentifierExpr();
                        columnNameExpr.value = "COLUMN_NAME";
                        this.formatExpr(columnNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.TABNAME.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "TABLE_NAME";
                        this.formatExpr(tableNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_TABNAME.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "TABLE_NAME";
                        this.formatExpr(tableNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CREATETIME.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "CREATE_TIME";
                        this.formatExpr(tableNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.INDNAME.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "INDEX_NAME";
                        this.formatExpr(tableNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_NAME.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "CONSTRAINT_NAME";
                        this.formatExpr(tableNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TABNAME.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "TABLE_NAME";
                        this.formatExpr(tableNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TYPE.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "CONSTRAINT_TYPE";
                        this.formatExpr(tableNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_DEFAULT.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "DATA_DEFAULT";
                        this.formatExpr(tableNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NULLABLE.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "NULLABLE";
                        this.formatExpr(tableNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_TYPE.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "DATA_TYPE";
                        this.formatExpr(tableNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_LENGTH.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "DATA_LENGTH";
                        this.formatExpr(tableNameExpr);
                    } else {
                        this.formatExpr(item.expr);
                    }
                } else {
                    this.formatExpr(item.expr);
                }
                this.buffer.append(" ");
                this.buffer.append(item.alias.toUpperCase());
            } else if (item.expr instanceof SqlIdentifierExpr) {
                if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NAME.value)) {
                    columnNameExpr = new SqlIdentifierExpr();
                    columnNameExpr.value = "COLUMN_NAME";
                    this.formatExpr(columnNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.TABNAME.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "TABLE_NAME";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CREATETIME.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "CREATE_TIME";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.INDNAME.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "INDEX_NAME";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_NAME.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "CONSTRAINT_NAME";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TABNAME.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "TABLE_NAME";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TYPE.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "CONSTRAINT_TYPE";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_DEFAULT.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "DATA_DEFAULT";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NULLABLE.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "NULLABLE";
                    this.formatExpr(tableNameExpr, false);
                } else {
                    this.formatExpr(item.expr, false);
                }
            } else {
                this.formatExpr(item.expr, false);
            }
            flag = true;
        }
        if (select.tableSource != null) {
            this.buffer.append(" FROM ");
            this.formatTableSource(select.tableSource);
        } else {
            this.buffer.append(" FROM DUAL");
        }
        boolean whereFlag = false;
        if (select.condition != null) {
            this.buffer.append(" WHERE ");
            this.formatExpr(select.condition);
            whereFlag = true;
        }
        if (select.hierarchicalQueryClause != null) {
            if (select.hierarchicalQueryClause.startWithCondition != null) {
                this.buffer.append(" START WITH ");
                this.formatExpr(select.hierarchicalQueryClause.startWithCondition);
            }
            if (select.hierarchicalQueryClause.connectByCondition == null) {
                throw new FormaterException("connectByCondition is null");
            }
            this.buffer.append(" CONNECT BY ");
            this.formatExpr(select.hierarchicalQueryClause.connectByCondition);
        }
        if (select.groupBy.size() != 0) {
            this.buffer.append(" GROUP BY ");
            if (select.hasWithRollUp) {
                this.buffer.append("ROLLUP(");
            }
            flag = false;
            List groupBys = select.groupBy;
            for (int i = 0; i < groupBys.size(); ++i) {
                if (flag) {
                    this.buffer.append(", ");
                }
                SqlExpr expr = (SqlExpr)groupBys.get(i);
                this.paramData.changeGroupBy(select, expr);
                this.formatExpr(expr);
                flag = true;
            }
            if (select.hasWithRollUp) {
                this.buffer.append(")");
            }
        }
        if (select.having != null) {
            this.buffer.append(" HAVING ");
            this.formatExpr(select.having);
        }
        if (select.orderBy.size() != 0) {
            this.buffer.append(" ORDER BY ");
            flag = false;
            iterator = select.orderBy.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                SqlOrderByItem orderByIterm = (SqlOrderByItem)iterator.next();
                if (orderByIterm.chineseOrderByMode != -1) {
                    this.buffer.append("NLSSORT(");
                    this.formatExpr(orderByIterm.expr);
                    this.buffer.append(",'NLS_SORT=");
                    if (orderByIterm.chineseOrderByMode == 2) {
                        this.buffer.append("SCHINESE_PINYIN_M')");
                    } else if (orderByIterm.chineseOrderByMode == 3) {
                        this.buffer.append("SCHINESE_STROKE_M')");
                    } else if (orderByIterm.chineseOrderByMode == 4) {
                        this.buffer.append("SCHINESE_RADICAL_M')");
                    }
                } else {
                    this.formatExpr(orderByIterm.expr);
                }
                if (orderByIterm.mode == 0) {
                    this.buffer.append(" ASC");
                } else {
                    this.buffer.append(" DESC");
                }
                flag = true;
            }
        }
        if (select.limit != null) {
            if (select.orderBy.size() != 0 || select.groupBy.size() != 0) {
                this.buffer.append(") WHERE ROWNUM <= ");
                this.buffer.append(select.limit.value + select.limit.offset);
            } else {
                if (!whereFlag) {
                    this.buffer.append(" WHERE ROWNUM <= ");
                } else {
                    this.buffer.append(" AND ROWNUM <= ");
                }
                this.buffer.append(select.limit.value + select.limit.offset);
            }
            if (select.limit.type == 1) {
                throw new FormaterException("Not support");
            }
        }
    }

    @Override
    protected void formatTableSource(SqlTableSourceBase tableSource) throws FormaterException {
        if (tableSource == null) {
            return;
        }
        if (tableSource instanceof SqlTableSource) {
            SqlTableSource simpleTableSource = (SqlTableSource)tableSource;
            if (simpleTableSource.name.equalsIgnoreCase(Token.USERTABLES.value)) {
                this.buffer.append("(SELECT OBJECT_NAME TABLE_NAME,CREATED CREATE_TIME FROM USER_OBJECTS WHERE OBJECT_TYPE='TABLE' OR OBJECT_TYPE='VIEW')");
            } else if (simpleTableSource.name.equalsIgnoreCase(Token.USERCOLUMNS.value)) {
                this.buffer.append("USER_TAB_COLUMNS");
            } else if (simpleTableSource.name.equalsIgnoreCase(Token.SYSINDEXES.value)) {
                this.buffer.append("USER_INDEXESNEW");
            } else if (simpleTableSource.name.equalsIgnoreCase(Token.SYSCONSTRAINTS.value)) {
                this.buffer.append("USER_CONSTRAINTS");
            } else if (simpleTableSource.name.equalsIgnoreCase("KSQL_USERVIEWS")) {
                this.buffer.append("(SELECT VIEW_NAME KSQL_VIEWNAME,TEXT KSQL_VIEWTEXT FROM USER_VIEWS)");
            } else {
                this.buffer.append(simpleTableSource.name);
            }
            if (simpleTableSource.alias != null && simpleTableSource.alias.length() != 0) {
                this.buffer.append(" ");
                this.buffer.append(simpleTableSource.alias.toUpperCase());
            }
            if (simpleTableSource.lockingHint != null && simpleTableSource.lockingHint.length() > 0 && "holdlock".equalsIgnoreCase(simpleTableSource.lockingHint)) {
                this.buffer.append(" FOR UPDATE");
            }
        } else if (tableSource instanceof SqlJoinedTableSource) {
            SqlJoinedTableSource joinedTable = (SqlJoinedTableSource)tableSource;
            this.formatTableSource(joinedTable.left);
            switch (joinedTable.joinType) {
                case 4: {
                    this.buffer.append(", ");
                    break;
                }
                case 3: {
                    this.buffer.append(" FULL OUTER JOIN ");
                    break;
                }
                case 0: {
                    this.buffer.append(" INNER JOIN ");
                    break;
                }
                case 1: {
                    this.buffer.append(" LEFT OUTER JOIN ");
                    break;
                }
                case 2: {
                    this.buffer.append(" RIGHT OUTER JOIN ");
                    break;
                }
                default: {
                    throw new FormaterException("error");
                }
            }
            this.formatTableSource(joinedTable.right);
            if (joinedTable.condition != null) {
                this.buffer.append(" ON ");
                this.formatExpr(joinedTable.condition);
            }
        } else if (tableSource instanceof SqlSubQueryTableSource) {
            SqlSubQueryTableSource subQueryTableSource = (SqlSubQueryTableSource)tableSource;
            this.buffer.append("(");
            this.formatSelectBase(subQueryTableSource.subQuery);
            this.buffer.append(")");
            if (tableSource.alias != null) {
                this.buffer.append(" ");
                this.buffer.append(tableSource.alias.toUpperCase());
            }
        } else {
            throw new FormaterException("not support tableSource:" + tableSource);
        }
    }
}

