/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.sql.shell.trace;

import com.kingdee.bos.sql.DbType;
import com.kingdee.bos.sql.shell.trace.ConnectionLogger;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class LogItem
implements Serializable {
    public String sqlplan_id;
    public long bytes;
    public String url;
    public int sql_id = -1;
    public int conn_id = -1;
    public String username;
    public String password;
    public String method;
    public Timestamp executeTime;
    public int dbType;
    public String ksql;
    public String dialect_sql;
    public String errorMessage;
    public long timespan;
    public long transtimespan;
    public int updateCount;
    public String traceInfo;
    public List parameters = new ArrayList();
    public List parametersMapping = new ArrayList();

    public int getSql_id() {
        if (this.sql_id == -1) {
            this.sql_id = this.dialect_sql == null ? System.identityHashCode(this) : (this.dialect_sql + ";" + this.url + ";" + this.username).hashCode();
        }
        return this.sql_id;
    }

    public void setSql_id(int sql_id) {
        this.sql_id = sql_id;
    }

    public LogItem getSerializableLogItem() {
        boolean flag = false;
        int size = this.parameters.size();
        for (int i = 0; i < size; ++i) {
            Object o = this.parameters.get(i);
            if (o instanceof Serializable) continue;
            flag = true;
            break;
        }
        if (flag) {
            Object o;
            int i;
            LogItem item = new LogItem();
            item.method = this.method;
            item.executeTime = this.executeTime;
            item.dbType = this.dbType;
            item.ksql = this.ksql;
            item.dialect_sql = this.dialect_sql;
            item.errorMessage = this.errorMessage;
            item.timespan = this.timespan;
            item.transtimespan = this.transtimespan;
            item.updateCount = this.updateCount;
            int size2 = this.parameters.size();
            for (i = 0; i < size2; ++i) {
                o = this.parameters.get(i);
                if (o instanceof Serializable) {
                    item.parameters.add(o);
                    continue;
                }
                item.parameters.add(o.toString());
            }
            size2 = this.parametersMapping.size();
            for (i = 0; i < size2; ++i) {
                o = this.parametersMapping.get(i);
                if (o instanceof Serializable) {
                    item.parametersMapping.add(o);
                    continue;
                }
                item.parametersMapping.add(o.toString());
            }
        }
        return this;
    }

    public String toString() {
        Object pram;
        int i;
        int size;
        StringBuffer buff = new StringBuffer();
        buff.append("URL:");
        buff.append(this.url);
        buff.append(ConnectionLogger.LINE_SEPARATOR);
        buff.append(this.method);
        buff.append(ConnectionLogger.LINE_SEPARATOR);
        buff.append("execute time : ");
        buff.append(this.executeTime.toString());
        buff.append(ConnectionLogger.LINE_SEPARATOR);
        buff.append("dbType : ");
        buff.append(DbType.getName(this.dbType));
        buff.append(ConnectionLogger.LINE_SEPARATOR);
        buff.append("K-SQL : ");
        buff.append(ConnectionLogger.LINE_SEPARATOR);
        buff.append(this.ksql);
        buff.append(ConnectionLogger.LINE_SEPARATOR);
        buff.append("$--------------------------------------------------------------");
        buff.append(ConnectionLogger.LINE_SEPARATOR);
        buff.append("Dialect-SQL : ");
        buff.append(ConnectionLogger.LINE_SEPARATOR);
        buff.append(this.dialect_sql);
        buff.append(ConnectionLogger.LINE_SEPARATOR);
        buff.append("$--------------------------------------------------------------");
        buff.append(ConnectionLogger.LINE_SEPARATOR);
        buff.append("timespan : ");
        buff.append(this.timespan);
        buff.append(ConnectionLogger.LINE_SEPARATOR);
        buff.append("trans timespan : ");
        buff.append(this.transtimespan);
        buff.append(ConnectionLogger.LINE_SEPARATOR);
        buff.append("updateCount : ");
        buff.append(this.updateCount);
        buff.append(ConnectionLogger.LINE_SEPARATOR);
        if (this.parameters != null && this.parameters.size() > 0) {
            buff.append("Parameters : ");
            buff.append(ConnectionLogger.LINE_SEPARATOR);
            size = this.parameters.size();
            for (i = 0; i < size; ++i) {
                pram = this.parameters.get(i);
                buff.append(i + 1);
                buff.append(" : ");
                if (pram == null) {
                    buff.append("null");
                } else if (pram instanceof String) {
                    buff.append('\'');
                    buff.append(((String)pram).replaceAll("'", "''"));
                    buff.append('\'');
                } else {
                    buff.append(pram);
                }
                buff.append(ConnectionLogger.LINE_SEPARATOR);
            }
        }
        if (this.parametersMapping != null && this.parametersMapping.size() > 0) {
            buff.append("Parameters After Mapping : ");
            buff.append(ConnectionLogger.LINE_SEPARATOR);
            size = this.parametersMapping.size();
            for (i = 0; i < size; ++i) {
                pram = this.parametersMapping.get(i);
                buff.append(i + 1);
                buff.append(" : ");
                if (pram == null) {
                    buff.append("null");
                } else if (pram instanceof String) {
                    buff.append('\'');
                    buff.append(((String)pram).replaceAll("'", "''"));
                    buff.append('\'');
                } else {
                    buff.append(pram);
                }
                buff.append(ConnectionLogger.LINE_SEPARATOR);
            }
        }
        if (this.traceInfo != null) {
            buff.append("$--------------------------------------------------------------");
            buff.append("Trace Stack Information");
            buff.append(ConnectionLogger.LINE_SEPARATOR);
            buff.append(this.traceInfo);
            buff.append(ConnectionLogger.LINE_SEPARATOR);
        }
        buff.append(ConnectionLogger.LINE_SEPARATOR);
        return buff.toString();
    }

    private static Object readObject(DataInputStream dataIn) throws IOException {
        Object obj;
        byte type = dataIn.readByte();
        switch (type) {
            case 9: {
                obj = dataIn.readBoolean();
                break;
            }
            case 1: {
                obj = dataIn.readInt();
                break;
            }
            case 2: {
                obj = dataIn.readLong();
                break;
            }
            case 4: {
                obj = new Timestamp(dataIn.readLong());
                break;
            }
            case 5: {
                obj = new java.util.Date(dataIn.readLong());
                break;
            }
            case 6: {
                obj = new Date(dataIn.readLong());
                break;
            }
            case 7: {
                obj = LogItem.readString(dataIn);
                break;
            }
            case 3: {
                obj = new Byte(dataIn.readByte());
                break;
            }
            case 0: {
                ObjectInputStream objIn = new ObjectInputStream(dataIn);
                try {
                    obj = objIn.readObject();
                    break;
                }
                catch (ClassNotFoundException e) {
                    throw new IOException(e.getMessage());
                }
            }
            default: {
                throw new IOException("TODO");
            }
        }
        return obj;
    }

    private static void writeObject(DataOutputStream dataOut, Object obj) throws IOException {
        if (obj instanceof String) {
            dataOut.writeByte(7);
            LogItem.writeString(dataOut, (String)obj);
        } else if (obj instanceof Byte) {
            dataOut.writeByte(3);
            dataOut.writeInt(((Byte)obj).byteValue());
        } else if (obj instanceof Integer) {
            dataOut.writeByte(1);
            dataOut.writeInt((Integer)obj);
        } else if (obj instanceof Boolean) {
            dataOut.writeByte(9);
            dataOut.writeBoolean((Boolean)obj);
        } else if (obj instanceof Long) {
            dataOut.writeByte(2);
            dataOut.writeLong((Long)obj);
        } else if (obj instanceof Timestamp) {
            dataOut.writeByte(4);
            dataOut.writeLong(((Timestamp)obj).getTime());
        } else if (obj instanceof java.util.Date) {
            dataOut.writeByte(5);
            dataOut.writeLong(((java.util.Date)obj).getTime());
        } else if (obj instanceof Date) {
            dataOut.writeByte(6);
            dataOut.writeLong(((Date)obj).getTime());
        } else {
            dataOut.writeByte(0);
            ObjectOutputStream objOut = new ObjectOutputStream(dataOut);
            objOut.writeObject(obj);
        }
    }

    private static String readString(DataInputStream dataIn) throws IOException {
        int len = dataIn.readInt();
        if (len == -1) {
            return null;
        }
        if (len == 0) {
            return "";
        }
        char[] charArray = new char[len];
        for (int i = 0; i < len; ++i) {
            charArray[i] = dataIn.readChar();
        }
        return new String(charArray);
    }

    private static void writeString(DataOutputStream dataOut, String val) throws IOException {
        if (val == null) {
            dataOut.writeInt(-1);
        } else if (val.length() == 0) {
            dataOut.writeInt(0);
        } else {
            dataOut.writeInt(val.length());
            dataOut.writeChars(val);
        }
    }

    public static LogItem readLogItem(InputStream in) throws IOException {
        DataInputStream dataIn = new DataInputStream(in);
        LogItem item = new LogItem();
        item.method = LogItem.readString(dataIn);
        item.executeTime = new Timestamp(dataIn.readLong());
        item.dbType = dataIn.readInt();
        item.ksql = LogItem.readString(dataIn);
        item.dialect_sql = LogItem.readString(dataIn);
        item.errorMessage = LogItem.readString(dataIn);
        item.timespan = dataIn.readLong();
        item.transtimespan = dataIn.readLong();
        item.updateCount = dataIn.readInt();
        int pramsCount = dataIn.readInt();
        for (int i = 0; i < pramsCount; ++i) {
            Object obj = LogItem.readObject(dataIn);
            item.parameters.add(obj);
        }
        int pramsMapCount = dataIn.readInt();
        for (int i = 0; i < pramsMapCount; ++i) {
            Object obj = LogItem.readObject(dataIn);
            item.parametersMapping.add(obj);
        }
        return item;
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.toByteArray(out);
        return out.toByteArray();
    }

    public void toByteArray(OutputStream out) throws IOException {
        int i;
        DataOutputStream dataOut = new DataOutputStream(out);
        LogItem.writeString(dataOut, this.method);
        dataOut.writeLong(this.executeTime.getTime());
        dataOut.writeInt(this.dbType);
        LogItem.writeString(dataOut, this.ksql);
        LogItem.writeString(dataOut, this.dialect_sql);
        LogItem.writeString(dataOut, this.errorMessage);
        dataOut.writeLong(this.timespan);
        dataOut.writeLong(this.transtimespan);
        dataOut.writeInt(this.updateCount);
        dataOut.writeInt(this.parameters.size());
        int pramsCount = this.parameters.size();
        for (i = 0; i < pramsCount; ++i) {
            LogItem.writeObject(dataOut, this.parameters.get(i));
        }
        dataOut.writeInt(this.parametersMapping.size());
        pramsCount = this.parametersMapping.size();
        for (i = 0; i < pramsCount; ++i) {
            LogItem.writeObject(dataOut, this.parametersMapping.get(i));
        }
    }

    public static class Constants {
        public static final byte OBJECT = 0;
        public static final byte INT = 1;
        public static final byte LONG = 2;
        public static final byte BYTE = 3;
        public static final byte TIMESAMP = 4;
        public static final byte DATE_UTIL = 5;
        public static final byte DATE_SQL = 6;
        public static final byte STRING = 7;
        public static final byte SHORT = 8;
        public static final byte BOOLEAN = 9;
    }
}

