/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.loadbalance.distributer;

import com.kingdee.bos.rpc.loadbalance.distributer.ILBDConfigAgent;
import com.kingdee.bos.rpc.loadbalance.distributer.LBDConfig;
import com.kingdee.bos.rpc.loadbalance.distributer.LBDConfigException;
import com.kingdee.bos.rpc.loadbalance.distributer.LBDConfigGroup;
import com.kingdee.bos.rpc.loadbalance.distributer.LBDConfigItem;
import com.kingdee.bos.rpc.loadbalance.distributer.LBDConfigReloadListener;
import com.kingdee.bos.rpcwrapper.RPCEngineFactory;
import com.kingdee.bos.service.ORMServiceLocation;
import com.kingdee.bos.util.XMLParser;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;

public class LBDConfigManager {
    public static final String LBD_CONFIG = "lbd.config";
    public static final String DEFAULT_LBD_CONFIG = "lbdistributer.xml";
    private static Logger logger = Logger.getLogger(LBDConfigManager.class);
    private static LBDConfig config;
    private static List listeners;

    public static LBDConfig getConfig() {
        if (config != null) {
            return config;
        }
        ORMServiceLocation loc = new ORMServiceLocation("license");
        if (!loc.isLocal()) {
            String url = loc.getServiceURL();
            logger.info((Object)("master url: " + url));
            ILBDConfigAgent agent = (ILBDConfigAgent)RPCEngineFactory.getEngine((String)url).createObject("com.kingdee.bos.rpc.loadbalance.distributer.LBDConfigAgent", ILBDConfigAgent.class);
            config = agent.getConfig();
        } else {
            LBDConfigManager.parseConfigFile();
        }
        return config;
    }

    static LBDConfig getLocalConfig() {
        if (config != null) {
            return config;
        }
        LBDConfigManager.parseConfigFile();
        return config;
    }

    private static void parseConfigFile() {
        String fileName = System.getProperty(LBD_CONFIG);
        if (fileName == null) {
            String bosConfig = System.getProperty("bos.config");
            if (bosConfig != null) {
                fileName = new File(bosConfig).getParent() + "/" + DEFAULT_LBD_CONFIG;
            } else {
                throw new LBDConfigException("Not set system property: lbd.config");
            }
        }
        config = new LBDConfig();
        if (!new File(fileName).exists()) {
            logger.warn((Object)(fileName + " not exist!"));
            return;
        }
        try {
            Document doc = XMLParser.parseXML((InputStream)new FileInputStream(fileName));
            Element root = doc.getRootElement();
            List eles = root.getChildren("group");
            if (eles == null) {
                return;
            }
            for (Element groupEle : eles) {
                LBDConfigGroup group = new LBDConfigGroup();
                config.addGroup(group);
                String enable = groupEle.getAttributeValue("enable");
                if ("false".equalsIgnoreCase(enable)) {
                    group.setEnable(false);
                }
                List items = groupEle.getChildren("LBDistributer");
                for (Element ele : items) {
                    List params;
                    String ais;
                    String priority;
                    LBDConfigItem item = new LBDConfigItem();
                    group.addItem(item);
                    item.setName(ele.getAttributeValue("name"));
                    if ("false".equalsIgnoreCase(ele.getAttributeValue("enable"))) {
                        item.setEnable(false);
                    }
                    if (!StringUtils.isEmpty((String)(priority = ele.getAttributeValue("priority")))) {
                        try {
                            int p = Integer.parseInt(priority);
                            item.setPriority(p);
                        }
                        catch (NumberFormatException e) {
                            logger.warn((Object)e, (Throwable)e);
                        }
                    }
                    if (!StringUtils.isEmpty((String)(ais = ele.getAttributeValue("ais")))) {
                        item.setAis(ais);
                    }
                    if ((params = ele.getChildren("parameter")) == null) continue;
                    for (Element param : params) {
                        String key = param.getAttributeValue("key");
                        String value = param.getAttributeValue("value");
                        item.addParameter(key, value);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new LBDConfigException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reload() {
        config = null;
        ORMServiceLocation loc = new ORMServiceLocation("license");
        if (!loc.isLocal()) {
            String url = loc.getServiceURL();
            logger.info((Object)("master url: " + url));
            ILBDConfigAgent agent = (ILBDConfigAgent)RPCEngineFactory.getEngine((String)url).createObject("com.kingdee.bos.rpc.loadbalance.distribute.LBDConfigAgent", ILBDConfigAgent.class);
            agent.reload();
            config = agent.getConfig();
        } else {
            LBDConfigManager.parseConfigFile();
        }
        List list = listeners;
        synchronized (list) {
            for (LBDConfigReloadListener l : listeners) {
                l.reload();
            }
        }
    }

    static void localReload() {
        config = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerListener(LBDConfigReloadListener l) {
        List list = listeners;
        synchronized (list) {
            listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterListener(LBDConfigReloadListener l) {
        List list = listeners;
        synchronized (list) {
            listeners.remove(l);
        }
    }

    static {
        listeners = new ArrayList();
    }
}

