/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.loadbalance.distributer;

import com.kingdee.bos.rpc.io.loadbalance.IRPCServer;
import com.kingdee.bos.rpc.io.loadbalance.RPCServerView;
import com.kingdee.util.StringUtils;
import com.kingdee.util.marshal.ExternalizeDelegate;
import com.kingdee.util.marshal.IMarshalObject;
import com.kingdee.util.marshal.Marshaller;
import com.kingdee.util.marshal.Unmarshaller;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;

public class LBDServer
implements IMarshalObject {
    private IRPCServer delegate;

    public LBDServer(IRPCServer s) {
        this.delegate = s;
    }

    public String getUrl() {
        return this.delegate.getUrl();
    }

    public float getPerformanceFactor() {
        return this.delegate.getPerformanceFactor();
    }

    public float getPerformance() {
        return this.delegate.getPerformance();
    }

    public int getConnectionCount() {
        return this.delegate.getConnectionCount();
    }

    public boolean connectionFailed() {
        return this.delegate.connectionFailed();
    }

    public float getHealthDegree() {
        return this.delegate.getHealthDegree();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public String getEngineId() {
        return this.delegate.getEngineId();
    }

    public void marshal(Marshaller marshaller) throws IOException {
        marshaller.writeObject((Object)this.delegate);
    }

    public void unmarshal(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        this.delegate = (IRPCServer)unmarshaller.readObject();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        new ExternalizeDelegate((IMarshalObject)this).readExternal(in);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        new ExternalizeDelegate((IMarshalObject)this).writeExternal(out);
    }

    public static LBDServer[] getServers(RPCServerView sv) {
        if (sv == null) {
            return null;
        }
        IRPCServer[] ss = sv.getServers();
        if (ss != null && ss.length > 0) {
            ArrayList<LBDServer> list = new ArrayList<LBDServer>();
            for (int i = 0; i < ss.length; ++i) {
                if (ss[i].connectionFailed()) continue;
                list.add(new LBDServer(ss[i]));
            }
            return list.toArray(new LBDServer[0]);
        }
        return null;
    }

    public static LBDServer[] getServersByParameterValue(LBDServer[] servers, String value) {
        if (servers == null || StringUtils.isEmpty((String)value)) {
            return servers;
        }
        ArrayList<LBDServer> list = new ArrayList<LBDServer>();
        String[] ss = value.split(",");
        for (int i = 0; i < ss.length; ++i) {
            for (int j = 0; j < servers.length; ++j) {
                if (!servers[j].getName().equalsIgnoreCase(ss[i].trim())) continue;
                list.add(servers[j]);
            }
        }
        if (list.size() > 0) {
            return list.toArray(new LBDServer[0]);
        }
        return null;
    }
}

