/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.loadbalance.distributer;

import com.kingdee.bos.Context;
import com.kingdee.bos.rpc.io.loadbalance.RPCServerView;
import com.kingdee.bos.rpc.loadbalance.distributer.AbstractLBDistributer;
import com.kingdee.bos.rpc.loadbalance.distributer.LBDConfig;
import com.kingdee.bos.rpc.loadbalance.distributer.LBDConfigGroup;
import com.kingdee.bos.rpc.loadbalance.distributer.LBDConfigItem;
import com.kingdee.bos.rpc.loadbalance.distributer.LBDConfigManager;
import com.kingdee.bos.rpc.loadbalance.distributer.LBDServer;
import com.kingdee.bos.rpc.loadbalance.distributer.LBDistributer;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class LBDistributerManager {
    private static Logger logger = Logger.getLogger(LBDistributerManager.class);
    private static LBDConfig config;
    private static List lbds;

    private static void init() {
        LBDConfigItem[] items;
        config = LBDConfigManager.getConfig();
        LBDConfigGroup group = config.getEnableGroup();
        if (group != null && (items = group.getItems()) != null) {
            for (int j = 0; j < items.length; ++j) {
                try {
                    LBDConfigItem item = items[j];
                    Class<?> c = Class.forName(item.getName());
                    LBDistributer d = (LBDistributer)c.newInstance();
                    if (d instanceof AbstractLBDistributer) {
                        AbstractLBDistributer ad = (AbstractLBDistributer)d;
                        ad.setEnable(item.isEnable());
                        ad.setPriority(item.getPriority());
                        ad.setAis(item.getAis());
                        ad.setParameters(item.getParameter());
                    }
                    LBDistributerManager.insert(d);
                    continue;
                }
                catch (Exception e) {
                    logger.warn((Object)e, (Throwable)e);
                }
            }
        }
    }

    private static void insert(LBDistributer lbd) {
        if (lbds.size() == 0) {
            lbds.add(lbd);
            return;
        }
        boolean insert = false;
        for (int i = 0; i < lbds.size(); ++i) {
            LBDistributer current = (LBDistributer)lbds.get(i);
            if (lbd.getPriority() >= current.getPriority()) continue;
            lbds.add(i, lbd);
            insert = true;
            break;
        }
        if (!insert) {
            lbds.add(lbd);
        }
    }

    public static synchronized void register(LBDistributer lbd) {
        LBDistributerManager.insert(lbd);
    }

    public static synchronized void unregister(LBDistributer lbd) {
        lbds.remove(lbd);
    }

    public static synchronized String redistribute(Context ctx) {
        LBDServer[] eid;
        if (lbds != null && lbds.size() > 0 && (eid = LBDServer.getServers(RPCServerView.getLast())) != null && eid.length > 0) {
            for (int i = lbds.size() - 1; i >= 0; --i) {
                LBDServer[] rv;
                LBDistributer lbd = (LBDistributer)lbds.get(i);
                if (!lbd.isEnable() || !StringUtils.isEmpty((String)lbd.getAis()) && !ctx.getAIS().equals(lbd.getAis()) || (rv = lbd.redistribute(eid, ctx)) == null || rv.length <= 0) continue;
                if (rv.length == 1) {
                    return rv[0].getEngineId();
                }
                eid = rv;
            }
            if (eid != null && eid.length > 0) {
                return eid[0].getEngineId();
            }
        }
        return null;
    }

    static {
        lbds = new ArrayList();
        try {
            LBDistributerManager.init();
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }
}

