/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.loadbalance.distributer;

import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.cache.CachedInvokeInterceptor2;
import com.kingdee.bos.framework.session.LoginContext;
import com.kingdee.bos.rpc.io.driver.SocketPool;
import com.kingdee.bos.rpc.loadbalance.distributer.IRemoteLBDistributer;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class LBDistributerUtil {
    private static Logger logger = Logger.getLogger(LBDistributerUtil.class);

    public static void redistribute(LoginContext ctx) {
        if (!SocketPool.isByLB()) {
            return;
        }
        String url = null;
        if (System.getProperty("EAS_SERVER") != null) {
            url = System.getProperty("EAS_SERVER");
        } else {
            try {
                Class<?> c = Class.forName("com.kingdee.eas.base.uiframe.client.UIConfig");
                Method m = c.getMethod("getUrl", null);
                url = (String)m.invoke(null, null);
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
                return;
            }
        }
        try {
            Context userContext = new Context(null, ctx.getSlnName(), ctx.getAis(), ctx.getLocale(), ctx.getContextID());
            userContext.setUserName(ctx.getUserName());
            userContext.setClientHostIP(ctx.getClientHostIP());
            userContext.setClientHostName(ctx.getClientHostName());
            LBDistributerUtil.fillContext(ctx, userContext);
            IRemoteLBDistributer lbd = (IRemoteLBDistributer)BOSObjectFactory.createRemoteObject((String)url, (String)"com.kingdee.bos.rpc.loadbalance.distributer.RemoteLBDistributer", IRemoteLBDistributer.class);
            String engineId = lbd.redistribute(userContext);
            if (engineId != null && !engineId.equalsIgnoreCase(SocketPool.getPool((String)url).getEngineId())) {
                logger.info((Object)("old engineId: " + SocketPool.getPool((String)url).getEngineId()));
                logger.info((Object)("new engineId: " + engineId));
                BOSObjectFactory.getRemoteBOSObjectFactory((String)url).clearSession();
                SocketPool.getPool((String)url).clear();
                SocketPool.getPool((String)url).setEngineId(engineId);
                CachedInvokeInterceptor2.setRedistributed((boolean)true);
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    private static void fillContext(LoginContext lgCtx, Context ctx) {
        Iterator it = lgCtx.items.entrySet().iterator();
        Map.Entry entry = null;
        while (it.hasNext()) {
            entry = it.next();
            ctx.put(entry.getKey(), entry.getValue());
        }
    }
}

