/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.message;

import com.kingdee.bos.service.message.Destination;
import com.kingdee.util.Configuration;
import com.kingdee.util.ConfigurationItem;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class DestinationManager {
    private static Map destinations = new Hashtable();
    private static final Logger log = Logger.getLogger((String)"com.kingdee.bos.service.message.DestinationManager");
    private static boolean bLoaded;
    private static String defaultDestinationName;

    public static Map getDestinations() {
        if (!bLoaded) {
            DestinationManager.loadDestinations();
        }
        return destinations;
    }

    public static Destination getDestination(String name) {
        if (!bLoaded) {
            DestinationManager.loadDestinations();
        }
        return (Destination)destinations.get(name);
    }

    private static void loadDestinations() {
        Configuration config = Configuration.getInstance();
        List items = config.getConfigItemByPath("MessageService/Destinations").getAllChildren();
        for (int i = 0; i < items.size(); ++i) {
            ConfigurationItem item = (ConfigurationItem)items.get(i);
            Destination dest = DestinationManager.loadDestinationFromConfigItem(item);
            if (dest == null) continue;
            destinations.put(item.getName(), dest);
        }
        ConfigurationItem messageServiceConfig = config.getConfigItem("MessageService");
        if (messageServiceConfig != null) {
            defaultDestinationName = messageServiceConfig.getProperty("defaultDestination", "default");
        } else {
            log.error((Object)"MessageService configuration error,not found MessageService ConfigurationItem in Configuration xml file");
        }
        bLoaded = true;
    }

    private static Destination loadDestinationFromConfigItem(ConfigurationItem configItem) {
        Destination dest = null;
        String name = configItem.getName();
        String driverClassName = configItem.getProperty("driverClassName");
        String url = configItem.getProperty("url");
        String type = configItem.getProperty("type");
        ConfigurationItem propertyItem = configItem.getChild("properties");
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)propertyItem.getProperties());
        if (type != null && type.length() != 0) {
            try {
                Class<?> destClass = Class.forName(type);
                Constructor<?> destCons = destClass.getConstructor(String.class, String.class, String.class, Properties.class);
                dest = (Destination)destCons.newInstance(name, driverClassName, url, properties);
            }
            catch (InvocationTargetException ex) {
                Throwable target = ex.getTargetException();
                log.error((Object)("error load destionation " + name), (Throwable)ex);
                log.error((Object)("cause exception is " + target.getMessage()), target);
            }
            catch (IllegalArgumentException ex) {
                log.error((Object)("error load destionation " + name), (Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                log.error((Object)("error load destionation " + name), (Throwable)ex);
            }
            catch (InstantiationException ex) {
                log.error((Object)("error load destionation " + name), (Throwable)ex);
            }
            catch (SecurityException ex) {
                log.error((Object)("error load destionation " + name), (Throwable)ex);
            }
            catch (NoSuchMethodException ex) {
                log.error((Object)("error load destionation " + name), (Throwable)ex);
            }
            catch (ClassNotFoundException ex) {
                log.error((Object)("error load destionation " + name), (Throwable)ex);
            }
        } else {
            dest = new Destination(name, driverClassName, url, properties);
        }
        return dest;
    }

    public static Destination getDefaultDestination() {
        if (!bLoaded) {
            DestinationManager.loadDestinations();
        }
        if (defaultDestinationName != null) {
            return DestinationManager.getDestination(defaultDestinationName);
        }
        return null;
    }
}

