/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.message;

import com.kingdee.bos.service.message.Connection;
import com.kingdee.bos.service.message.Destination;
import com.kingdee.bos.service.message.DriverInfo;
import com.kingdee.bos.service.message.MessageDriver;
import com.kingdee.bos.service.message.MessageException;
import com.kingdee.bos.service.message.jms.queue.JMSQueueDriver;
import com.kingdee.bos.service.message.jms.topic.JMSTopicDriver;
import com.kingdee.bos.service.message.mail.MailDriver;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import org.apache.log4j.Logger;

public class MessageDriverManager {
    private static ArrayList drivers = new ArrayList();
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.service.message.MessageDriverManager");

    private MessageDriverManager() {
    }

    public static Connection getConnection(Destination destination, Properties props) throws MessageException {
        return destination.getConnection(props);
    }

    public static synchronized void registerDriver(MessageDriver driver) throws MessageException {
        DriverInfo di = new DriverInfo();
        di.driver = driver;
        di.driverClass = driver.getClass();
        di.driverClassName = di.driverClass.getName();
        drivers.add(di);
    }

    public static synchronized void deregisterDriver(MessageDriver driver) throws MessageException {
        int i;
        DriverInfo di = null;
        for (i = 0; i < drivers.size(); ++i) {
            di = (DriverInfo)drivers.get(i);
            if (di.driver == driver) break;
        }
        if (i >= drivers.size()) {
            return;
        }
        drivers.remove(i);
    }

    public static Connection getConnection(String url, Properties info) throws MessageException {
        if (url == null) {
            throw new MessageException("The url cannot be null");
        }
        MessageException reason = null;
        for (int i = 0; i < drivers.size(); ++i) {
            DriverInfo di = (DriverInfo)drivers.get(i);
            try {
                Connection result = di.driver.connect(url, info);
                if (result == null) continue;
                logger.debug((Object)("getConnection returning " + di));
                return result;
            }
            catch (MessageException ex) {
                if (reason != null) continue;
                reason = ex;
            }
        }
        if (reason != null) {
            throw reason;
        }
        throw new MessageException("No suitable driver");
    }

    public static synchronized Iterator getDrivers() {
        return drivers.iterator();
    }

    public static MessageDriver getDriver(String url) throws MessageException {
        for (int i = 0; i < drivers.size(); ++i) {
            DriverInfo di = (DriverInfo)drivers.get(i);
            try {
                if (!di.driver.acceptsURL(url)) continue;
                logger.debug((Object)("getDriver returning " + di));
                return di.driver;
            }
            catch (MessageException messageException) {
                // empty catch block
            }
        }
        throw new MessageException("No suitable driver");
    }

    static {
        try {
            MessageDriverManager.registerDriver(new JMSTopicDriver());
            MessageDriverManager.registerDriver(new JMSQueueDriver());
            MessageDriverManager.registerDriver(new MailDriver());
        }
        catch (MessageException e) {
            e.printStackTrace();
        }
    }
}

