/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.message.agent;

import com.kingdee.bos.service.message.Connection;
import com.kingdee.bos.service.message.MessageConsumer;
import com.kingdee.bos.service.message.MessageException;
import com.kingdee.bos.service.message.MessageListener;
import java.util.Properties;

public class ListenerInfo {
    public String name;
    public String doamin;
    public String filter;
    public MessageListener listener;
    public MessageConsumer consumer;

    public ListenerInfo(String name, String domain, String filter, MessageListener listener) {
        this.name = name;
        this.doamin = domain;
        this.filter = filter;
        this.listener = listener;
    }

    public void open(Connection conn) throws MessageException {
        Properties prop = new Properties();
        prop.put("messageDomianPrefix", this.doamin);
        if (this.filter != null && this.filter.length() > 0) {
            prop.setProperty("filter", this.filter);
        }
        this.consumer = conn.createRecevier(prop);
        this.consumer.setMessageListener(this.listener);
    }

    public void close() throws MessageException {
        if (this.consumer != null) {
            this.consumer.close();
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ListenerInfo) {
            ListenerInfo info = (ListenerInfo)obj;
            if (info.listener == null || info == null || info.listener == null) {
                return false;
            }
            if (info.name.equals(this.name)) {
                if (info.listener == this.listener) {
                    return true;
                }
                if (info.listener.getClass() == this.getClass()) {
                    return true;
                }
                if (info.listener.getClass().getName().equals(this.listener.getClass().getName())) {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("name=").append(this.name).append(";");
        sbuf.append("domain=").append(this.doamin).append(";");
        sbuf.append("filter=").append(this.filter).append(";");
        sbuf.append("listener=").append(this.listener.getClass().getName()).append(";");
        sbuf.append("consumer=").append(this.consumer.getClass().getName());
        return sbuf.toString();
    }
}

