/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.message.agent;

import com.kingdee.bos.service.message.Connection;
import com.kingdee.bos.service.message.Destination;
import com.kingdee.bos.service.message.DestinationManager;
import com.kingdee.bos.service.message.JMSLocalTransactionException;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.MessageException;
import com.kingdee.bos.service.message.MessageProducer;
import com.kingdee.bos.service.message.TransactionSupport;
import com.kingdee.bos.service.message.agent.Agent;
import com.kingdee.bos.service.message.agent.BOSMessageService;
import com.kingdee.bos.service.message.agent.DirectLocalTransactionSenderAgent;
import com.kingdee.bos.service.message.agent.DirectSenderAgent;
import com.kingdee.bos.service.message.agent.Transformer;
import com.kingdee.util.Configuration;
import com.kingdee.util.ConfigurationItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class LocalTransactionSenderAgent
implements Agent {
    private int state = 0;
    private static ArrayList transformers = new ArrayList();
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.service.message.agent.LocalTransactionSenderAgent");
    private Connection conn;
    private static Destination dest;
    private MessageProducer producer;
    private static boolean bLoaded;

    public void beginSend() throws MessageException {
        if (this.getState() != 1) {
            this.start();
            if (this.getState() != 1) {
                throw new MessageException("sender cannot start!");
            }
        }
        long t = System.currentTimeMillis();
        Properties props = new Properties();
        props.put("transactionSupport", "true");
        this.producer = this.conn.createSender(props);
        long t2 = System.currentTimeMillis() - t;
        if (t2 > 100L) {
            log.warn((Object)("get jms session use " + t2 + "ms"));
        } else {
            log.debug((Object)("get jms session use " + t2 + "ms"));
        }
    }

    protected LocalTransactionSenderAgent() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LocalTransactionSenderAgent getInstance() {
        Class<LocalTransactionSenderAgent> clazz = LocalTransactionSenderAgent.class;
        synchronized (LocalTransactionSenderAgent.class) {
            if (!bLoaded) {
                LocalTransactionSenderAgent.init();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            if (BOSMessageService.getServiceType().equals(BOSMessageService.SERVICE_TYPE_DIRECT)) {
                DirectSenderAgent senderAgent = new DirectSenderAgent();
                senderAgent.init();
                senderAgent.start();
                DirectLocalTransactionSenderAgent agent = new DirectLocalTransactionSenderAgent(senderAgent);
                return agent;
            }
            LocalTransactionSenderAgent agent = new LocalTransactionSenderAgent();
            agent.start();
            return agent;
        }
    }

    @Override
    public void start() {
        if (this.state == 1) {
            return;
        }
        try {
            long t = System.currentTimeMillis();
            this.conn = dest.getConnection(null);
            long t1 = System.currentTimeMillis() - t;
            if (t1 > 100L) {
                log.warn((Object)("get jms connection use " + t1 + "ms"));
            } else {
                log.debug((Object)("get jms connection use " + t1 + "ms"));
            }
        }
        catch (MessageException ex) {
            log.error((Object)"agent get connection from destination error ", (Throwable)((Object)ex));
        }
        if (this.conn == null) {
            log.error((Object)"agent create connection error ");
        } else {
            this.state = 1;
        }
    }

    public void sendMessage(Message msg) throws MessageException {
        if (this.producer == null) {
            this.beginSend();
        }
        if (this.state != 1) {
            throw new IllegalStateException("sender agent not running");
        }
        Message source = msg;
        for (int i = 0; i < transformers.size(); ++i) {
            Transformer trans = (Transformer)transformers.get(i);
            source = trans.transforme(source);
        }
        this.sendToDestination(source, this.producer);
    }

    public void sendCommit() throws JMSLocalTransactionException {
        try {
            if (this.producer != null && this.producer instanceof TransactionSupport) {
                ((TransactionSupport)((Object)this.producer)).commit();
            }
        }
        finally {
            if (this.producer != null) {
                try {
                    this.producer.close();
                }
                catch (MessageException e) {
                    log.error((Object)"close producer error", (Throwable)((Object)e));
                }
            }
            this.producer = null;
        }
    }

    public void rollback() throws JMSLocalTransactionException {
        if (this.producer != null && this.producer instanceof TransactionSupport) {
            ((TransactionSupport)((Object)this.producer)).rollback();
        }
    }

    public void closeSender() {
        if (this.getState() != 1) {
            return;
        }
        try {
            this.sendCommit();
        }
        catch (JMSLocalTransactionException e) {
            log.error((Object)"commit error!", (Throwable)e);
        }
        finally {
            if (this.producer != null) {
                try {
                    this.producer.close();
                }
                catch (MessageException e) {
                    log.error((Object)"close producer error ", (Throwable)((Object)e));
                }
            }
            this.producer = null;
            if (this.conn != null) {
                try {
                    this.conn.close();
                }
                catch (MessageException e) {
                    log.error((Object)"close connection error ", (Throwable)((Object)e));
                }
            }
            this.conn = null;
            this.state = 2;
        }
    }

    protected static void init() {
        if (bLoaded) {
            return;
        }
        dest = DestinationManager.getDefaultDestination();
        if (dest == null) {
            throw new RuntimeException("Message Service configuration error!");
        }
        ConfigurationItem config = Configuration.getInstance().getConfigItemByPath("MessageService/transformers");
        if (config == null) {
            log.info((Object)"no transformers Configuration found!");
            bLoaded = true;
            return;
        }
        List transformerConfigs = config.getAllChildren();
        for (int i = 0; i < transformerConfigs.size(); ++i) {
            ConfigurationItem item = (ConfigurationItem)transformerConfigs.get(i);
            String className = item.getProperty("class");
            if (className == null || className.length() == 0) continue;
            Transformer transformer = null;
            try {
                Class<?> transformerClass = Class.forName(className);
                transformer = (Transformer)transformerClass.newInstance();
            }
            catch (IllegalAccessException ex) {
                log.error((Object)"cannot load transformer class!", (Throwable)ex);
            }
            catch (InstantiationException ex) {
                log.error((Object)"cannot load transformer class!", (Throwable)ex);
            }
            catch (ClassNotFoundException ex) {
                log.error((Object)"cannot load transformer class!", (Throwable)ex);
            }
            if (transformer == null) continue;
            transformers.add(transformer);
        }
        bLoaded = true;
    }

    void sendToDestination(Message msg, MessageProducer producer) throws MessageException {
        long t = 0L;
        if (log.isDebugEnabled()) {
            log.debug((Object)("send message:" + msg.getBody() + " to destination"));
            t = System.currentTimeMillis();
        }
        producer.send(msg);
        if (log.isDebugEnabled() && (t = System.currentTimeMillis() - t) > 50L) {
            log.debug((Object)("send message use " + t + "ms."));
        }
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public void stop() {
        this.closeSender();
    }

    static {
        bLoaded = false;
    }
}

