/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.message.agent;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.orm.IORMModel;
import com.kingdee.bos.orm.template.ORMObject;
import com.kingdee.bos.service.ORMServiceLocation;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.Sender;
import com.kingdee.bos.service.message.agent.SenderAgent;
import org.apache.log4j.Logger;

public class MessageSender
extends ORMObject
implements Sender {
    public static final String CONFIG_ITEM_MESSAGE = "message";
    private static final Logger logger = Logger.getLogger(MessageSender.class);

    public static Sender getInstance() {
        ORMServiceLocation loc = new ORMServiceLocation(CONFIG_ITEM_MESSAGE);
        if (loc.isLocal()) {
            return new MessageSender();
        }
        return MessageSender.getInstance(loc.getServiceURL());
    }

    public static Sender getInstance(String url) {
        IORMModel sender = null;
        try {
            sender = BOSObjectFactory.createRemoteObject((String)url, (String)"com.kingdee.bos.service.message.agent.MessageSender", Sender.class);
        }
        catch (BOSException e) {
            logger.error((Object)"cannot create remote object", (Throwable)e);
        }
        return (Sender)sender;
    }

    public MessageSender() {
        super.registerInterface(Sender.class, (Object)this);
    }

    @Override
    public void sendMessage(Message msg) {
        this.sendMessage(msg, false);
    }

    @Override
    public void sendMessage(Message msg, boolean transacted) {
        SenderAgent.getSenderAgent().sendMessage(msg, transacted);
    }
}

