/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.message.agent;

import com.kingdee.bos.service.message.Connection;
import com.kingdee.bos.service.message.Destination;
import com.kingdee.bos.service.message.DestinationManager;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.MessageException;
import com.kingdee.bos.service.message.MessageProducer;
import com.kingdee.bos.service.message.agent.Agent;
import com.kingdee.bos.service.message.agent.BOSMessageService;
import com.kingdee.bos.service.message.agent.DirectSenderAgent;
import com.kingdee.bos.service.message.agent.SenderAgentStateless;
import com.kingdee.bos.service.message.agent.Transformer;
import com.kingdee.util.Configuration;
import com.kingdee.util.ConfigurationItem;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class SenderAgent
implements Agent {
    private int state = 0;
    private ArrayList transformers = new ArrayList();
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.service.message.agent.SenderAgent");
    private Connection conn;
    Destination dest;
    private MessageProducer producer;
    private boolean bLoaded = false;
    private static volatile SenderAgent senderAgent;

    public void sendMessage(Message msg) {
        this.sendMessage(msg, false);
    }

    public void sendMessage(Message msg, boolean transacted) {
        if (this.state != 1) {
            throw new IllegalStateException("sender agent not running");
        }
        Message source = msg;
        for (int i = 0; i < this.transformers.size(); ++i) {
            Transformer trans = (Transformer)this.transformers.get(i);
            source = trans.transforme(source);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"call sendMessage(Message msg)");
        }
        this.sendToDestination(source);
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public void start() {
        if (this.state == 1) {
            return;
        }
        try {
            this.conn = this.dest.getConnection(null);
            this.producer = this.conn.createSender(null);
        }
        catch (MessageException ex) {
            log.error((Object)"agent get connection from destination error ", (Throwable)((Object)ex));
        }
        if (this.producer == null) {
            log.error((Object)"agent create producer error ");
        } else {
            this.state = 1;
            log.info((Object)"senderAgent started!");
        }
    }

    @Override
    public void stop() {
        if (this.state != 1) {
            log.warn((Object)"sender agent is already stoped!");
            return;
        }
        try {
            this.producer.close();
            this.conn.close();
            this.state = 2;
            log.info((Object)"senderAgent closed");
        }
        catch (MessageException ex) {
            log.error((Object)"stop agent error", (Throwable)((Object)ex));
        }
    }

    protected void init() {
        this.dest = DestinationManager.getDefaultDestination();
        if (this.dest == null) {
            throw new RuntimeException("Message Service configuration error!");
        }
        this.loadTransformers();
    }

    protected SenderAgent() {
    }

    private void loadTransformers() {
        if (this.bLoaded) {
            return;
        }
        ConfigurationItem config = Configuration.getInstance().getConfigItemByPath("MessageService/transformers");
        if (config == null) {
            log.info((Object)"no transformers Configuration found!");
            return;
        }
        List transformerConfigs = config.getAllChildren();
        for (int i = 0; i < transformerConfigs.size(); ++i) {
            ConfigurationItem item = (ConfigurationItem)transformerConfigs.get(i);
            String className = item.getProperty("class");
            if (className == null || className.length() == 0) continue;
            Transformer transformer = null;
            try {
                Class<?> transformerClass = Class.forName(className);
                transformer = (Transformer)transformerClass.newInstance();
            }
            catch (IllegalAccessException ex) {
                log.error((Object)"cannot load transformer class!", (Throwable)ex);
            }
            catch (InstantiationException ex) {
                log.error((Object)"cannot load transformer class!", (Throwable)ex);
            }
            catch (ClassNotFoundException ex) {
                log.error((Object)"cannot load transformer class!", (Throwable)ex);
            }
            if (transformer == null) continue;
            this.transformers.add(transformer);
        }
        this.bLoaded = true;
    }

    void sendToDestination(Message msg) {
        try {
            long t = 0L;
            if (log.isDebugEnabled()) {
                log.debug((Object)("send message:" + msg.getBody() + " to destination"));
                t = System.currentTimeMillis();
            }
            this.producer.send(msg);
            if (log.isDebugEnabled() && (t = System.currentTimeMillis() - t) > 50L) {
                log.debug((Object)("send message use " + t + "ms."));
            }
        }
        catch (MessageException ex) {
            log.error((Object)"send message to destination error", (Throwable)((Object)ex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static SenderAgent getSenderAgent() {
        if (senderAgent == null) {
            Class<SenderAgent> clazz = SenderAgent.class;
            // MONITORENTER : com.kingdee.bos.service.message.agent.SenderAgent.class
            if (senderAgent == null) {
                senderAgent = BOSMessageService.SERVICE_TYPE_DIRECT.equals(BOSMessageService.getServiceType()) ? new DirectSenderAgent() : (BOSMessageService.SERVICE_TYPE_JMS_CACHE.equals(BOSMessageService.getServiceType()) ? new SenderAgent() : new SenderAgentStateless());
                senderAgent.init();
                senderAgent.start();
            }
            // MONITOREXIT : clazz
        }
        if (!log.isDebugEnabled()) return senderAgent;
        log.debug((Object)"call getSenderAgent");
        return senderAgent;
    }
}

