/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.message.agent;

import com.kingdee.bos.service.message.Connection;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.MessageException;
import com.kingdee.bos.service.message.MessageProducer;
import com.kingdee.bos.service.message.agent.Agent;
import com.kingdee.bos.service.message.agent.SenderAgent;
import com.kingdee.bos.service.message.agent.Transformer;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.log4j.Logger;

public class SenderAgentStateless
extends SenderAgent
implements Agent {
    private int state = 0;
    private ArrayList transformers = new ArrayList();
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.service.message.agent.SenderAgentStateless");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessage(Message msg, boolean transacted) {
        if (this.state != 1) {
            throw new IllegalStateException("sender agent not running");
        }
        Connection conn = null;
        MessageProducer producer = null;
        try {
            long t = System.currentTimeMillis();
            conn = this.dest.getConnection(null);
            long t1 = System.currentTimeMillis() - t;
            if (t1 > 100L) {
                log.warn((Object)("get jms connection use " + t1 + "ms"));
            } else {
                log.debug((Object)("get jms connection use " + t1 + "ms"));
            }
            t = System.currentTimeMillis();
            if (transacted) {
                Properties props = new Properties();
                props.put("transactionSupport", "true");
                producer = conn.createSender(props);
            } else {
                producer = conn.createSender(null);
            }
            long t2 = System.currentTimeMillis() - t;
            if (t2 > 100L) {
                log.warn((Object)("get jms session use " + t2 + "ms"));
            } else {
                log.debug((Object)("get jms session use " + t2 + "ms"));
            }
            Message source = msg;
            for (int i = 0; i < this.transformers.size(); ++i) {
                Transformer trans = (Transformer)this.transformers.get(i);
                source = trans.transforme(source);
            }
            this.sendToDestination(source, producer);
        }
        catch (MessageException ex) {
            log.error((Object)"agent get connection from destination error ", (Throwable)((Object)ex));
        }
        finally {
            if (producer != null) {
                try {
                    producer.close();
                }
                catch (MessageException e) {
                    log.error((Object)"close producer error ", (Throwable)((Object)e));
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (MessageException e) {
                    log.error((Object)"close connection error ", (Throwable)((Object)e));
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"call sendMessage(Message msg)");
        }
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public void start() {
        if (this.state == 1) {
            return;
        }
        this.state = 1;
        log.info((Object)"senderAgent started!");
    }

    @Override
    public void stop() {
        if (this.state != 1) {
            log.warn((Object)"sender agent is already stoped!");
            return;
        }
        this.state = 2;
        log.info((Object)"senderAgent closed");
    }

    void sendToDestination(Message msg, MessageProducer producer) {
        try {
            long t = 0L;
            if (log.isDebugEnabled()) {
                log.debug((Object)("send message:" + msg.getBody() + " to destination"));
                t = System.currentTimeMillis();
            }
            producer.send(msg);
            if (log.isDebugEnabled() && (t = System.currentTimeMillis() - t) > 50L) {
                log.debug((Object)("send message use " + t + "ms."));
            }
        }
        catch (MessageException ex) {
            log.error((Object)"send message to destination error", (Throwable)((Object)ex));
        }
    }
}

