/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.message.jms;

import java.util.HashMap;
import java.util.Hashtable;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.jms.Topic;
import javax.jms.TopicConnectionFactory;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class JMSCache {
    private HashMap jmsMap;
    private InitialContext ctx;
    private Hashtable env;
    private static HashMap jmsCacheMap;
    private static JMSCache defaultJMSEnv;
    private boolean isLocal = true;

    private JMSCache(Hashtable env) {
        this.env = env;
        this.isLocal = false;
    }

    private JMSCache() {
    }

    private void lazyInitContext() throws NamingException {
        if (this.ctx == null) {
            this.ctx = this.isLocal ? new InitialContext() : new InitialContext(this.env);
        }
    }

    Object getJNIDObject(String jndiName) throws NamingException {
        this.lazyInitContext();
        if (this.jmsMap == null) {
            this.jmsMap = new HashMap(2);
            Object jndiObject = this.ctx.lookup(jndiName);
            this.jmsMap.put(jndiName, jndiObject);
            return jndiObject;
        }
        if (!this.jmsMap.containsKey(jndiName)) {
            Object jndiObject = this.ctx.lookup(jndiName);
            this.jmsMap.put(jndiName, jndiObject);
            return jndiObject;
        }
        return this.jmsMap.get(jndiName);
    }

    public Topic getTopic(String jndiName) throws NamingException {
        return (Topic)this.getJNIDObject(jndiName);
    }

    public Queue getQueue(String jndiName) throws NamingException {
        return (Queue)this.getJNIDObject(jndiName);
    }

    public TopicConnectionFactory getTopicConnectionFactory(String jndiName) throws NamingException {
        return (TopicConnectionFactory)this.getJNIDObject(jndiName);
    }

    public QueueConnectionFactory getQueueConnectionFactory(String jndiName) throws NamingException {
        return (QueueConnectionFactory)this.getJNIDObject(jndiName);
    }

    public static JMSCache getDefaultJMSEnv() {
        if (defaultJMSEnv == null) {
            defaultJMSEnv = new JMSCache();
        }
        return defaultJMSEnv;
    }

    public static JMSCache getJMSCache(Hashtable env) {
        if (env == null) {
            return JMSCache.getDefaultJMSEnv();
        }
        String serverUrl = (String)env.get("java.naming.provider.url");
        if (serverUrl == null || serverUrl.length() == 0) {
            throw new IllegalArgumentException("java.naming.provider.url cannot be null");
        }
        if (jmsCacheMap == null) {
            jmsCacheMap = new HashMap(1);
            JMSCache instance = new JMSCache(env);
            jmsCacheMap.put(serverUrl, instance);
            return instance;
        }
        JMSCache instance = (JMSCache)jmsCacheMap.get(serverUrl);
        if (instance == null) {
            instance = new JMSCache(env);
            jmsCacheMap.put(serverUrl, instance);
        }
        return instance;
    }
}

