/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.message.jms;

import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.jms.TextMessage;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import javax.jms.JMSException;
import javax.jms.Session;

public class MessageConvert {
    public static final String MESSAGE_DOMAIN_PROPERTY_NAME = "BosMessageDomain";
    public static final String MESSAGE_ID_PROPERTY_NAME = "BosMessageID";
    public static final String MESSAGE_TIMSTEMP_PROPERTY_NAME = "BosMessageTimestamp";
    public static final String MESSAGE_HEADER_NAME_FREFIX = "BosHeader_";

    public static javax.jms.Message convertToJMS(Session session, Message message) throws JMSException {
        if (session != null) {
            javax.jms.TextMessage jmsMessage = session.createTextMessage();
            String domain = message.getDomian();
            if (domain != null) {
                jmsMessage.setStringProperty(MESSAGE_DOMAIN_PROPERTY_NAME, domain);
            }
            jmsMessage.setLongProperty(MESSAGE_TIMSTEMP_PROPERTY_NAME, message.getTimestamp());
            jmsMessage.setStringProperty(MESSAGE_ID_PROPERTY_NAME, message.getMessageID());
            Enumeration e = message.getHeaderNames();
            while (e.hasMoreElements()) {
                String headerName = (String)e.nextElement();
                Object header = message.getObjectHeader(headerName);
                if (header == null) continue;
                jmsMessage.setObjectProperty(MESSAGE_HEADER_NAME_FREFIX + headerName, header);
            }
            jmsMessage.setText(message.getBody());
            return jmsMessage;
        }
        return null;
    }

    public static Message convertFromJMS(javax.jms.Message message) throws JMSException {
        javax.jms.TextMessage txtMessage = (javax.jms.TextMessage)message;
        String messageID = txtMessage.getStringProperty(MESSAGE_ID_PROPERTY_NAME);
        long timestamp = txtMessage.getLongProperty(MESSAGE_TIMSTEMP_PROPERTY_NAME);
        if (messageID == null) {
            return null;
        }
        TextMessage rtMessage = new TextMessage(messageID, timestamp);
        String domain = message.getStringProperty(MESSAGE_DOMAIN_PROPERTY_NAME);
        if (domain != null) {
            rtMessage.setDomian(domain);
        }
        Enumeration e = message.getPropertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!name.startsWith(MESSAGE_HEADER_NAME_FREFIX)) continue;
            String headerName = name.substring(MESSAGE_HEADER_NAME_FREFIX.length());
            Object header = message.getObjectProperty(name);
            rtMessage.setObjectHeader(headerName, header);
        }
        rtMessage.setBody(txtMessage.getText());
        return rtMessage;
    }

    public static String dumpMessage(javax.jms.TextMessage message) {
        StringBuffer sb = new StringBuffer();
        if (message == null) {
            return "Message is null.";
        }
        try {
            Enumeration e = message.getPropertyNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                Object property = message.getObjectProperty(name);
                sb.append("\n[");
                sb.append(name);
                sb.append("] = ");
                sb.append(property == null ? "null" : property.toString());
            }
            String body = message.getText();
            sb.append("\nMessage body is: \n");
            sb.append(body);
            sb.append("\n");
        }
        catch (JMSException e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter((Writer)sw, true));
            sb.append("error while dump ");
            sb.append(sw.toString());
        }
        return sb.toString();
    }
}

