/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.message.jms;

import com.kingdee.bos.service.message.Message;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.Uuid;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;

public class TextMessage
implements Message {
    private static final long serialVersionUID = 8928987324938344973L;
    private final HashMap headers = new HashMap();
    private String domain = "kingdee";
    final String messageID;
    final long timestamp;
    private StringBuffer buffer = new StringBuffer(2048);

    public TextMessage() {
        this.timestamp = System.currentTimeMillis();
        this.messageID = Uuid.create().toString();
    }

    TextMessage(String messageID, long timestamp) {
        this.timestamp = timestamp;
        this.messageID = messageID;
    }

    public void setText(String text) {
        this.buffer.delete(0, this.buffer.length());
        this.buffer.append(text);
    }

    public String getText() {
        return this.buffer.toString();
    }

    public void append(String text) {
        this.buffer.append(text);
    }

    @Override
    public String getMessageID() {
        return this.messageID;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getDomian() {
        return this.domain;
    }

    @Override
    public void setDomian(String domain) {
        this.domain = domain;
    }

    @Override
    public Object getHeaderValue(String name) {
        return this.headers.get(name);
    }

    @Override
    public boolean headerExists(String name) {
        return this.headers.containsKey(name);
    }

    @Override
    public boolean getBooleanheader(String name) {
        return TypeConversionUtils.objToBoolean(this.headers.get(name));
    }

    @Override
    public byte getByteHeader(String name) {
        return TypeConversionUtils.objToByte(this.headers.get(name));
    }

    @Override
    public short getShortHeader(String name) {
        return TypeConversionUtils.objToShort(this.headers.get(name));
    }

    @Override
    public int getIntHeader(String name) {
        return TypeConversionUtils.objToInt(this.headers.get(name));
    }

    @Override
    public long getLongHeader(String name) {
        return TypeConversionUtils.objToLong(this.headers.get(name));
    }

    @Override
    public float getFloatHeader(String name) {
        return TypeConversionUtils.objToFloat(this.headers.get(name));
    }

    @Override
    public double getDoubleHeader(String name) {
        return TypeConversionUtils.objToDouble(this.headers.get(name));
    }

    @Override
    public String getStringHeader(String name) {
        return TypeConversionUtils.objToString(this.headers.get(name));
    }

    @Override
    public String getLocaleStringHeader(String name, Locale locale) {
        return TypeConversionUtils.objToString(this.headers.get(name + locale));
    }

    @Override
    public Object getObjectHeader(String name) {
        return this.headers.get(name);
    }

    @Override
    public Enumeration getHeaderNames() {
        return Collections.enumeration(this.headers.keySet());
    }

    @Override
    public void setBooleanHeader(String name, boolean flag) {
        this.headers.put(name, flag);
    }

    @Override
    public void setByteHeader(String name, byte byte0) {
        this.headers.put(name, new Byte(byte0));
    }

    @Override
    public void setShortHeader(String name, short word0) {
        this.headers.put(name, new Short(word0));
    }

    @Override
    public void setIntHeader(String name, int i) {
        this.headers.put(name, new Integer(i));
    }

    @Override
    public void setLongHeader(String name, long l) {
        this.headers.put(name, new Long(l));
    }

    @Override
    public void setFloatHeader(String name, float f) {
        this.headers.put(name, new Float(f));
    }

    @Override
    public void setDoubleHeader(String name, double d) {
        this.headers.put(name, new Double(d));
    }

    @Override
    public void setStringHeader(String name, String value) {
        this.headers.put(name, value);
    }

    @Override
    public void setLocaleStringHeader(String name, String value, Locale locale) {
        this.headers.put(name + locale, value);
    }

    @Override
    public void setObjectHeader(String name, Object obj) {
        this.headers.put(name, obj);
    }

    @Override
    public void setBody(String body) {
        this.setText(body);
    }

    @Override
    public String getBody() {
        return this.getText();
    }
}

