/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.message.jms.grouptopic;

import com.kingdee.bos.service.message.Connection;
import com.kingdee.bos.service.message.MessageConsumer;
import com.kingdee.bos.service.message.MessageException;
import com.kingdee.bos.service.message.MessageProducer;
import com.kingdee.bos.service.message.jms.grouptopic.GroupTopicMessageProducer;
import java.util.Hashtable;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class GroupTopicConnection
implements Connection {
    public static final String TRANSACTION_SUPPORT = "transactionSupport";
    public static final String ACKNOWLEDGE_MODE = "acknowledgeMode";
    public static final boolean DEFAULT_TRANSACTION_SUPPORT = false;
    public static final String BE_DURABLE_PROPERTY_NAME = "durable";
    public static final String SUBSCRIBE_ID_PROPERTY_NAME = "subscribeId";
    public static final String CLIENT_ID_PROPERTY_NAME = "clientId";
    public static final int DEFAULT_ACKNOWLEDGE_MODE = 1;
    Context ctx = null;
    private TopicConnection topicConn;

    public GroupTopicConnection(String topicsExpression, Properties info) {
        String contextFactory = info.getProperty("contextFactory");
        String jndiUrl = info.getProperty("jndiURL");
        String securityCredential = info.getProperty("securityCredential");
        String securityPrincipal = info.getProperty("securityPrincipal");
        Hashtable<String, String> env = new Hashtable<String, String>();
        if (jndiUrl != null) {
            env.put("java.naming.provider.url", jndiUrl);
        }
        if (contextFactory != null) {
            env.put("java.naming.factory.initial", contextFactory);
        }
        if (securityCredential != null) {
            env.put("java.naming.security.credentials", securityCredential);
        }
        if (securityPrincipal != null) {
            env.put("java.naming.security.principal", securityPrincipal);
        }
        try {
            this.ctx = new InitialContext(env);
            String connectionFactoryJNDIName = info.getProperty("connectionFactoryJNDIName");
            if (connectionFactoryJNDIName == null) {
                throw new MessageException("connectionFactoryJNDIName is null");
            }
            TopicConnectionFactory topicConnectionFactory = (TopicConnectionFactory)this.ctx.lookup(connectionFactoryJNDIName);
            this.topicConn = topicConnectionFactory.createTopicConnection();
            this.topicConn.start();
            this.ctx.close();
        }
        catch (JMSException jMSException) {
        }
        catch (MessageException messageException) {
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    @Override
    public MessageProducer createSender(Properties props) throws MessageException {
        return new GroupTopicMessageProducer(this.topicConn, props);
    }

    @Override
    public MessageConsumer createRecevier(Properties props) throws MessageException {
        return null;
    }

    @Override
    public void close() throws MessageException {
        try {
            this.topicConn.close();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }
}

