/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.message.jms.grouptopic;

import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.MessageConsumer;
import com.kingdee.bos.service.message.MessageException;
import com.kingdee.bos.service.message.MessageListener;
import com.kingdee.bos.service.message.jms.JMSMessageListenerImpl;
import com.kingdee.bos.service.message.jms.grouptopic.TopicGroup;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.TopicConnection;
import javax.jms.TopicSubscriber;

public class GroupTopicMessageConsumer
implements MessageConsumer {
    TopicGroup topics;
    String selector;

    public GroupTopicMessageConsumer(TopicConnection topicConnection, Properties props) throws MessageException {
        this.topics = new TopicGroup(topicConnection, props);
        this.topics.openTopicsForConsume();
    }

    @Override
    public Message receive() throws MessageException {
        throw new MessageException("not allow invoke this method in topic group pattern");
    }

    @Override
    public Message receive(long timeout) throws MessageException {
        throw new MessageException("not allow invoke this method in topic group pattern");
    }

    @Override
    public Message receiveNoWait() throws MessageException {
        throw new MessageException("not allow invoke this method in topic group pattern");
    }

    @Override
    public void setMessageListener(MessageListener listener) throws MessageException {
        if (listener == null) {
            JMSMessageListenerImpl listenerImp = new JMSMessageListenerImpl(listener);
            try {
                TopicSubscriber subscriber = this.topics.getJMSTopicConsumer();
                subscriber.setMessageListener((javax.jms.MessageListener)listenerImp);
            }
            catch (JMSException ex) {
                throw new MessageException("JMS Exception", ex);
            }
        }
    }

    @Override
    public void close() throws MessageException {
        this.topics.close();
    }
}

